/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitable;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelSelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaDelete<T>
implements PersistentEntityCriteriaDelete<T>,
QueryResultPersistentEntityCriteriaQuery {
    protected Predicate predicate;
    protected PersistentEntityRoot<T> entityRoot;
    protected Selection<?> returning;

    @Override
    public QueryModel getQueryModel() {
        if (this.entityRoot == null) {
            throw new IllegalStateException("The root entity must be specified!");
        }
        QueryModel qm = QueryModel.from(this.entityRoot.getPersistentEntity());
        Joiner joiner = new Joiner();
        if (this.predicate instanceof PredicateVisitable) {
            PredicateVisitable predicate = (PredicateVisitable)this.predicate;
            predicate.accept(this.createPredicateVisitor(qm));
            predicate.accept(joiner);
        }
        if (this.returning instanceof SelectionVisitable) {
            SelectionVisitable selection = (SelectionVisitable)this.returning;
            selection.accept(new QueryModelSelectionVisitor(qm, false));
            selection.accept(joiner);
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        return qm;
    }

    @NonNull
    protected QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new QueryModelPredicateVisitor(queryModel);
    }

    @Override
    public QueryResult buildQuery(QueryBuilder queryBuilder) {
        return queryBuilder.buildDelete(this.getQueryModel());
    }

    @Override
    public abstract PersistentEntityRoot<T> from(Class<T> var1);

    @Override
    public abstract PersistentEntityRoot<T> from(PersistentEntity var1);

    @Override
    public PersistentEntityRoot<T> from(EntityType<T> entity) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Expression<Boolean> restriction) {
        this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).collect(Collectors.toList()))) : null;
        return this;
    }

    @Override
    public PersistentEntityRoot<T> getRoot() {
        return this.entityRoot;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        throw new IllegalStateException("Unsupported!");
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returning(Selection<? extends T> selection) {
        Objects.requireNonNull(selection);
        this.returning = selection;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.returning = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.returning = selections.length != 0 ? new CompoundSelection(List.of(selections)) : null;
        return this;
    }
}

