/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.model.DefaultCursoredPage;
import io.micronaut.data.model.DefaultPage;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@JsonIgnoreProperties(ignoreUnknown=true)
@TypeHint(value={Page.class})
@JsonDeserialize(as=DefaultPage.class)
@Serdeable
@DefaultImplementation(value=DefaultPage.class)
public interface Page<T>
extends Slice<T> {
    public static final Page<?> EMPTY = new DefaultPage(Collections.emptyList(), Pageable.unpaged(), -1L);

    public boolean hasTotalSize();

    public long getTotalSize();

    default public int getTotalPages() {
        int size = this.getSize();
        return size == 0 ? 1 : (int)Math.ceil((double)this.getTotalSize() / (double)size);
    }

    @Override
    default public boolean hasNext() {
        return this.hasTotalSize() ? this.getOffset() + (long)this.getSize() < this.getTotalSize() : this.getContent().size() == this.getSize();
    }

    @Override
    @NonNull
    default public <T2> Page<T2> map(Function<T, T2> function) {
        List<T2> content = this.getContent().stream().map(function).toList();
        return new DefaultPage<T2>(content, this.getPageable(), this.hasTotalSize() ? Long.valueOf(this.getTotalSize()) : null);
    }

    @ReflectiveAccess
    @NonNull
    public static <T> Page<T> of(@JsonProperty(value="content") @NonNull List<T> content, @JsonProperty(value="pageable") @NonNull Pageable pageable, @JsonProperty(value="totalSize") @Nullable Long totalSize) {
        return new DefaultPage<T>(content, pageable, totalSize);
    }

    @JsonCreator
    @Internal
    @ReflectiveAccess
    @NonNull
    public static <T> Page<T> ofCursors(@JsonProperty(value="content") @NonNull List<T> content, @JsonProperty(value="pageable") @NonNull Pageable pageable, @JsonProperty(value="cursors") @Nullable List<Pageable.Cursor> cursors, @JsonProperty(value="totalSize") @Nullable Long totalSize) {
        if (cursors == null) {
            return new DefaultPage<T>(content, pageable, totalSize);
        }
        return new DefaultCursoredPage<T>(content, pageable, cursors, totalSize);
    }

    @NonNull
    public static <T2> Page<T2> empty() {
        return EMPTY;
    }
}

