/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ExpressionBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyInPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyUnaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import jakarta.persistence.criteria.Expression;
import java.util.Collection;

@Internal
public interface AdvancedPredicateVisitor<P>
extends PredicateVisitor {
    public P getRequiredProperty(PersistentPropertyPath<?> var1);

    @Override
    default public void visit(PersistentPropertyUnaryPredicate<?> propertyOp) {
        P property = this.getRequiredProperty(propertyOp.getPropertyPath());
        switch (propertyOp.getOp()) {
            case IS_NULL: {
                this.visitIsNull(property);
                break;
            }
            case IS_NON_NULL: {
                this.visitIsNotNull(property);
                break;
            }
            case IS_TRUE: {
                this.visitIsTrue(property);
                break;
            }
            case IS_FALSE: {
                this.visitIsFalse(property);
                break;
            }
            case IS_EMPTY: {
                this.visitIsEmpty(property);
                break;
            }
            case IS_NOT_EMPTY: {
                this.visitIsNotEmpty(property);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported property operation: " + propertyOp.getOp());
            }
        }
    }

    @Override
    default public void visit(PersistentPropertyBetweenPredicate<?> propertyBetweenPredicate) {
        P property = this.getRequiredProperty(propertyBetweenPredicate.getPropertyPath());
        this.visitInBetween(property, propertyBetweenPredicate.getFrom(), propertyBetweenPredicate.getTo());
    }

    @Override
    default public void visit(PersistentPropertyBinaryPredicate<?> propertyToExpressionOp) {
        PersistentPropertyPath propertyPath = propertyToExpressionOp.getPropertyPath();
        PredicateBinaryOp op = propertyToExpressionOp.getOp();
        Expression<?> expression = propertyToExpressionOp.getExpression();
        this.visitPropertyPathPredicate(propertyPath, expression, op);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public void visit(ExpressionBinaryPredicate expressionBinaryPredicate) {
        Expression<?> left = expressionBinaryPredicate.getLeft();
        PredicateBinaryOp op = expressionBinaryPredicate.getOp();
        if (left instanceof PersistentPropertyPath) {
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)left;
            this.visitPropertyPathPredicate(persistentPropertyPath, expressionBinaryPredicate.getRight(), op);
            return;
        } else {
            if (!(left instanceof IdExpression)) throw new IllegalStateException("Unsupported expression: " + left);
            if (op != PredicateBinaryOp.EQUALS) throw new IllegalStateException("Unsupported ID expression OP: " + op);
            this.visitIdEquals(expressionBinaryPredicate.getRight());
        }
    }

    public void visitIdEquals(Expression<?> var1);

    default public void visitPropertyPathPredicate(PersistentPropertyPath<?> propertyPath, Expression<?> expression, PredicateBinaryOp op) {
        P leftProperty = this.getRequiredProperty(propertyPath);
        this.appendPredicateOfPropertyAndExpression(op, leftProperty, expression);
    }

    default public void appendPredicateOfPropertyAndExpression(PredicateBinaryOp op, P leftProperty, Expression<?> expression) {
        switch (op) {
            case EQUALS: {
                this.visitEquals(leftProperty, expression, false);
                break;
            }
            case NOT_EQUALS: {
                this.visitNotEquals(leftProperty, expression, false);
                break;
            }
            case EQUALS_IGNORE_CASE: {
                this.visitEquals(leftProperty, expression, true);
                break;
            }
            case NOT_EQUALS_IGNORE_CASE: {
                this.visitNotEquals(leftProperty, expression, true);
                break;
            }
            case GREATER_THAN: {
                this.visitGreaterThan(leftProperty, expression);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                this.visitGreaterThanOrEquals(leftProperty, expression);
                break;
            }
            case LESS_THAN: {
                this.visitLessThan(leftProperty, expression);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                this.visitLessThanOrEquals(leftProperty, expression);
                break;
            }
            case STARTS_WITH: {
                this.visitStartsWith(leftProperty, expression, false);
                break;
            }
            case STARTS_WITH_IGNORE_CASE: {
                this.visitStartsWith(leftProperty, expression, true);
                break;
            }
            case REGEX: {
                this.visitRegexp(leftProperty, expression);
                break;
            }
            case ARRAY_CONTAINS: {
                this.visitArrayContains(leftProperty, expression);
                break;
            }
            case CONTAINS: {
                this.visitContains(leftProperty, expression, false);
                break;
            }
            case CONTAINS_IGNORE_CASE: {
                this.visitContains(leftProperty, expression, true);
                break;
            }
            case ENDS_WITH: {
                this.visitEndsWith(leftProperty, expression, false);
                break;
            }
            case ENDS_WITH_IGNORE_CASE: {
                this.visitEndsWith(leftProperty, expression, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation: " + op);
            }
        }
    }

    public void visitContains(P var1, Expression<?> var2, boolean var3);

    public void visitEndsWith(P var1, Expression<?> var2, boolean var3);

    default public void visitRegexp(P leftProperty, Expression<?> expression) {
        throw new UnsupportedOperationException("Regexp is not supported by this implementation.");
    }

    default public void visitArrayContains(P leftProperty, Expression<?> expression) {
        throw new UnsupportedOperationException("ArrayContains is not supported by this implementation.");
    }

    public void visitStartsWith(P var1, Expression<?> var2, boolean var3);

    public void visitEquals(P var1, Expression<?> var2, boolean var3);

    public void visitNotEquals(P var1, Expression<?> var2, boolean var3);

    public void visitGreaterThan(P var1, Expression<?> var2);

    public void visitGreaterThanOrEquals(P var1, Expression<?> var2);

    public void visitLessThan(P var1, Expression<?> var2);

    public void visitLessThanOrEquals(P var1, Expression<?> var2);

    public void visitInBetween(P var1, Expression<?> var2, Expression<?> var3);

    public void visitIsFalse(P var1);

    public void visitIsNotNull(P var1);

    public void visitIsNull(P var1);

    public void visitIsTrue(P var1);

    public void visitIsEmpty(P var1);

    public void visitIsNotEmpty(P var1);

    @Override
    default public void visit(PersistentPropertyInPredicate<?> predicate) {
        this.visitIn(this.getRequiredProperty(predicate.getPropertyPath()), predicate.getValues(), false);
    }

    public void visitIn(P var1, Collection<?> var2, boolean var3);
}

