/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.init;

import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.data.mongodb.init.AbstractMongoCollectionsCreator;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Context
@Internal
@RequiresReactiveMongo
@Requires(property="micronaut.data.mongodb.create-collections", value="true")
public final class MongoReactiveCollectionsCreator
extends AbstractMongoCollectionsCreator<MongoDatabase> {
    @PostConstruct
    void initialize(BeanLocator beanLocator, RuntimeEntityRegistry runtimeEntityRegistry, List<AbstractMongoConfiguration> mongoConfigurations) {
        super.initialize(runtimeEntityRegistry, mongoConfigurations, (AbstractMongoConfiguration mongoConfiguration) -> {
            final MongoClient mongoClient = this.getMongoFactory(MongoClient.class, beanLocator, mongoConfiguration);
            final MongoDatabaseNameProvider mongoDatabaseNameProvider = this.getMongoFactory(MongoDatabaseNameProvider.class, beanLocator, mongoConfiguration);
            final HashMap databaseCollections = new HashMap();
            return new AbstractMongoCollectionsCreator.DatabaseOperations<MongoDatabase>(){

                @Override
                public String getDatabaseName(MongoDatabase database) {
                    return database.getName();
                }

                @Override
                public MongoDatabase find(PersistentEntity persistentEntity) {
                    return mongoClient.getDatabase(mongoDatabaseNameProvider.provide(persistentEntity));
                }

                @Override
                public Set<String> listCollectionNames(MongoDatabase database) {
                    return databaseCollections.computeIfAbsent(database.getName(), s -> (Set)Flux.from((Publisher)database.listCollectionNames()).collect(Collectors.toSet()).block());
                }

                @Override
                public void createCollection(MongoDatabase database, String collection) {
                    Mono.from((Publisher)database.createCollection(collection)).block();
                }
            };
        });
    }
}

