/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.data.runtime.convert.DataTypeConverter;
import java.util.Optional;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

@Factory
final class MongoConvertersFactory {
    MongoConvertersFactory() {
    }

    @Prototype
    DataTypeConverter<BsonValue, ObjectId> bsonValueAsObjectId() {
        return (value, targetType, context) -> {
            if (value.isObjectId()) {
                return Optional.of(value.asObjectId().getValue());
            }
            return Optional.empty();
        };
    }

    @Prototype
    DataTypeConverter<BsonValue, String> bsonValueAsString() {
        return (value, targetType, context) -> {
            if (value.isObjectId()) {
                return Optional.of(value.asObjectId().getValue().toHexString());
            }
            return Optional.empty();
        };
    }

    @Prototype
    DataTypeConverter<ObjectId, String> objectIdAsString() {
        return (value, targetType, context) -> Optional.of(value.toHexString());
    }
}

