/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ProjectionMethodExpression {
    private final int requiredProperties;

    ProjectionMethodExpression(int requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    @Nullable
    public static ProjectionMethodExpression matchProjection(@NonNull MethodMatchContext matchContext, @NonNull String projection) {
        String decapitilized;
        Class<?>[] innerClasses = ProjectionMethodExpression.class.getClasses();
        SourcePersistentEntity entity = matchContext.getRootEntity();
        Optional path = entity.getPath(decapitilized = NameUtils.decapitalize((String)projection));
        if (path.isPresent()) {
            return new Property().init(matchContext, projection);
        }
        for (Class<?> innerClass : innerClasses) {
            ProjectionMethodExpression pme;
            ProjectionMethodExpression initialized;
            Object o;
            String simpleName = innerClass.getSimpleName();
            if (!projection.startsWith(simpleName)) continue;
            try {
                o = innerClass.newInstance();
            }
            catch (Throwable e) {
                continue;
            }
            if (!(o instanceof ProjectionMethodExpression) || (initialized = (pme = (ProjectionMethodExpression)o).init(matchContext, projection)) == null) continue;
            return initialized;
        }
        if (!Arrays.asList("all", "one").contains(decapitilized)) {
            Matcher topMatcher = Pattern.compile("^(top|first)(\\d*)$").matcher(decapitilized);
            if (topMatcher.find()) {
                return new RestrictMaxResultProjection(topMatcher, matchContext).initProjection(matchContext, decapitilized);
            }
            if (!projection.equals(matchContext.getReturnType().getSimpleName())) {
                matchContext.fail("Cannot project on non-existent property: " + decapitilized);
            }
        }
        return null;
    }

    @Nullable
    protected final ProjectionMethodExpression init(@NonNull MethodMatchContext matchContext, @NonNull String projectionDefinition) {
        int len = this.getClass().getSimpleName().length();
        if (projectionDefinition.length() >= len && !this.getClass().equals(Property.class)) {
            String remaining = projectionDefinition.substring(len);
            return this.initProjection(matchContext, NameUtils.decapitalize((String)remaining));
        }
        return this.initProjection(matchContext, projectionDefinition);
    }

    @Nullable
    protected abstract ProjectionMethodExpression initProjection(@NonNull MethodMatchContext var1, @Nullable String var2);

    protected abstract void apply(@NonNull MethodMatchContext var1, @NonNull QueryModel var2);

    public int getRequiredProperties() {
        return this.requiredProperties;
    }

    @NonNull
    public abstract ClassElement getExpectedResultType();

    private static class RestrictMaxResultProjection
    extends ProjectionMethodExpression {
        private final Matcher topMatcher;
        private final MethodMatchContext matchContext;
        private int max;

        RestrictMaxResultProjection(Matcher topMatcher, MethodMatchContext matchContext) {
            super(0);
            this.topMatcher = topMatcher;
            this.matchContext = matchContext;
            this.max = -1;
        }

        @Override
        protected ProjectionMethodExpression initProjection(@NonNull MethodMatchContext matchContext, @Nullable String remaining) {
            String str = this.topMatcher.group(2);
            try {
                this.max = StringUtils.isNotEmpty((CharSequence)str) ? Integer.parseInt(str) : 1;
            }
            catch (NumberFormatException e) {
                matchContext.fail("Invalid number specified to top: " + str);
                return null;
            }
            return this;
        }

        @Override
        protected void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            if (this.max > -1) {
                query.max(this.max);
            }
        }

        @Override
        @NonNull
        public ClassElement getExpectedResultType() {
            return this.matchContext.getRootEntity().getClassElement();
        }
    }

    public static class Property
    extends ProjectionMethodExpression
    implements Named {
        private String property;
        private ClassElement expectedType;
        private SourcePersistentProperty persistentProperty;

        public Property() {
            super(1);
        }

        @Override
        protected ProjectionMethodExpression initProjection(@NonNull MethodMatchContext matchContext, String remaining) {
            if (StringUtils.isEmpty((CharSequence)remaining)) {
                matchContext.fail(this.getClass().getSimpleName() + " projection requires a property name");
                return null;
            }
            this.property = NameUtils.decapitalize((String)remaining);
            this.persistentProperty = matchContext.getRootEntity().getPropertyByPath(this.property).orElse(null);
            if (this.persistentProperty == null || this.persistentProperty.getType() == null) {
                matchContext.fail("Cannot project on non-existent property " + this.property);
                return null;
            }
            this.expectedType = this.resolveExpectedType(matchContext, this.persistentProperty.getType());
            return this;
        }

        protected ClassElement resolveExpectedType(@NonNull MethodMatchContext matchContext, @NonNull ClassElement classElement) {
            return classElement;
        }

        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            query.projections().property(this.property);
            if (this.persistentProperty instanceof Association && !query.getJoinPath(this.property).isPresent()) {
                query.join((Association)this.persistentProperty);
            }
        }

        @Override
        @NonNull
        public ClassElement getExpectedResultType() {
            return this.expectedType;
        }

        @NonNull
        public String getName() {
            return this.property;
        }
    }

    public static class Min
    extends Property {
        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            query.projections().min(this.getName());
        }

        @Override
        protected ProjectionMethodExpression initProjection(@NonNull MethodMatchContext matchContext, String remaining) {
            return super.initProjection(matchContext, remaining);
        }
    }

    public static class Avg
    extends Property {
        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            query.projections().avg(this.getName());
        }

        @Override
        protected ClassElement resolveExpectedType(@NonNull MethodMatchContext matchContext, @NonNull ClassElement classElement) {
            if (TypeUtils.isNumber(classElement)) {
                return matchContext.getVisitorContext().getClassElement(Number.class).orElse(super.resolveExpectedType(matchContext, classElement));
            }
            return super.resolveExpectedType(matchContext, classElement);
        }
    }

    public static class Sum
    extends Property {
        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            query.projections().sum(this.getName());
        }

        @Override
        protected ClassElement resolveExpectedType(@NonNull MethodMatchContext matchContext, @NonNull ClassElement classElement) {
            if (TypeUtils.isNumber(classElement)) {
                return matchContext.getVisitorContext().getClassElement(Number.class).orElse(super.resolveExpectedType(matchContext, classElement));
            }
            return super.resolveExpectedType(matchContext, classElement);
        }
    }

    public static class Max
    extends Property {
        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            query.projections().max(this.getName());
        }
    }

    public static class Distinct
    extends ProjectionMethodExpression {
        private String property;
        private ClassElement expectedType;

        public Distinct() {
            super(0);
        }

        @Override
        protected ProjectionMethodExpression initProjection(@NonNull MethodMatchContext matchContext, String remaining) {
            if (StringUtils.isEmpty((CharSequence)remaining)) {
                this.expectedType = matchContext.getRootEntity().getType();
                return this;
            }
            this.property = NameUtils.decapitalize((String)remaining);
            SourcePersistentProperty pp = matchContext.getRootEntity().getPropertyByName(this.property);
            if (pp == null || pp.getType() == null) {
                matchContext.fail("Cannot project on non-existent property " + this.property);
                return null;
            }
            this.expectedType = pp.getType();
            return this;
        }

        @Override
        public void apply(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query) {
            if (this.property == null) {
                query.projections().distinct();
            } else {
                query.projections().distinct(this.property);
            }
        }

        @Override
        @NonNull
        public ClassElement getExpectedResultType() {
            return this.expectedType;
        }
    }
}

