/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.AnnotationMetadataHierarchy;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.Restrictions;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCriteriaMethodMatch
implements MethodMatcher.MethodMatch {
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("(.*)ForUpdate$");
    private static final String OPERATOR_OR = "Or";
    private static final String OPERATOR_AND = "And";
    private static final String[] OPERATORS = new String[]{"And", "Or"};
    private static final String NOT = "Not";
    private static final Pattern[] OPERATOR_PATTERNS = new Pattern[OPERATORS.length];
    private static final Pattern PROPERTY_RESTRICTIONS_PATTERN;
    private static final Pattern RESTRICTIONS_PATTERN;
    @Nullable
    protected final Matcher matcher;

    protected AbstractCriteriaMethodMatch(Matcher matcher) {
        this.matcher = matcher;
    }

    @Nullable
    protected ParameterElement getEntityParameter() {
        return null;
    }

    @Nullable
    protected ParameterElement getEntitiesParameter() {
        return null;
    }

    @NonNull
    protected abstract MethodMatchInfo.OperationType getOperationType();

    protected boolean supportedByImplicitQueries() {
        return false;
    }

    @Override
    public final MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
        MethodMatchInfo methodMatchInfo;
        if (this.supportedByImplicitQueries() && matchContext.supportsImplicitQueries() && this.hasNoWhereDeclaration(matchContext)) {
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = this.resolveReturnTypeAndInterceptor(matchContext);
            methodMatchInfo = new MethodMatchInfo((TypedElement)entry.getKey(), this.getInterceptorElement(matchContext, entry.getValue()));
        } else {
            methodMatchInfo = this.build(matchContext);
        }
        ParameterElement entityParameter = this.getEntityParameter();
        ParameterElement entitiesParameter = this.getEntitiesParameter();
        ParameterElement idParameter = Arrays.stream(matchContext.getParameters()).filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
        if (idParameter != null) {
            methodMatchInfo.addParameterRole("id", idParameter.stringValue(Parameter.class).orElse(idParameter.getName()));
        }
        if (entityParameter != null) {
            methodMatchInfo.encodeEntityParameters(true);
            methodMatchInfo.addParameterRole("entity", entityParameter.getName());
        } else if (entitiesParameter != null) {
            methodMatchInfo.encodeEntityParameters(true);
            methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
        }
        return methodMatchInfo;
    }

    protected abstract MethodMatchInfo build(MethodMatchContext var1);

    protected final ClassElement getInterceptorElement(MethodMatchContext matchContext, Class<? extends DataInterceptor> interceptorType) {
        return FindersUtils.getInterceptorElement(matchContext, interceptorType);
    }

    protected Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
        ParameterElement entityParameter = this.getEntityParameter();
        ParameterElement entitiesParameter = this.getEntitiesParameter();
        return FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, this.getOperationType(), matchContext);
    }

    @Nullable
    private Predicate extractPredicates(List<ParameterElement> queryParams, PersistentEntityRoot<?> root, SourcePersistentEntityCriteriaBuilder cb) {
        if (CollectionUtils.isNotEmpty(queryParams)) {
            PersistentEntity rootEntity = root.getPersistentEntity();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(queryParams.size());
            for (ParameterElement queryParam : queryParams) {
                String paramName = queryParam.getName();
                PersistentProperty prop = rootEntity.getPropertyByName(paramName);
                ParameterExpression<Object> param = cb.parameter(queryParam);
                if (prop == null) {
                    if ("id".equals(paramName) && (rootEntity.hasIdentity() || rootEntity.hasCompositeIdentity())) {
                        predicates.add(cb.equal(root.id(), (Expression)param));
                        continue;
                    }
                    throw new MatchFailedException("Cannot query persistentEntity [" + rootEntity.getSimpleName() + "] on non-existent property: " + paramName);
                }
                if (prop == rootEntity.getIdentity()) {
                    predicates.add(cb.equal(root.id(), (Expression)param));
                    continue;
                }
                if (prop == rootEntity.getVersion()) {
                    predicates.add(cb.equal((Expression)root.version(), (Expression)param));
                    continue;
                }
                predicates.add(cb.equal((Expression)root.get(prop.getName()), (Expression)param));
            }
            if (predicates.isEmpty()) {
                return null;
            }
            return cb.and(predicates);
        }
        return null;
    }

    protected <T> void applyPredicates(String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(querySequence, parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void applyPredicates(String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaDelete<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(querySequence, parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void applyPredicates(String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(querySequence, parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void applyPredicates(List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void applyPredicates(List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void applyPredicates(List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaDelete<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(parameters, root, cb);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    private <T> Predicate extractPredicates(String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, SourcePersistentEntityCriteriaBuilder cb) {
        Predicate predicate = null;
        Iterator<ParameterElement> parametersIt = Arrays.asList(parameters).iterator();
        boolean containsOperator = false;
        if (querySequence != null) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (int i = 0; i < OPERATORS.length; ++i) {
                Matcher currentMatcher = OPERATOR_PATTERNS[i].matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                String operatorInUse = OPERATORS[i];
                String[] queryParameters = querySequence.split(operatorInUse);
                ArrayList<Predicate> opPredicates = new ArrayList<Predicate>();
                for (String queryParameter : queryParameters) {
                    opPredicates.add(this.findMethodPredicate(queryParameter, root, cb, parametersIt));
                }
                if (opPredicates.isEmpty()) break;
                if (OPERATOR_OR.equals(operatorInUse)) {
                    predicates.add(cb.or(opPredicates));
                    break;
                }
                predicates.add(cb.and(opPredicates));
                break;
            }
            if (!predicates.isEmpty()) {
                predicate = cb.and(predicates);
            }
        }
        if (!containsOperator && querySequence != null) {
            predicate = this.findMethodPredicate(querySequence, root, cb, parametersIt);
        }
        return predicate;
    }

    private <T> Predicate findMethodPredicate(String expression, PersistentEntityRoot<T> root, SourcePersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters) {
        Matcher matcher = PROPERTY_RESTRICTIONS_PATTERN.matcher(expression);
        if (matcher.find()) {
            Restrictions.PropertyRestriction restriction;
            String restrictionName = matcher.group(1);
            String propertyName = AbstractCriteriaMethodMatch.extractPropertyName(expression, restrictionName);
            if (StringUtils.isEmpty((CharSequence)propertyName)) {
                throw new MatchFailedException("Missing property name for restriction: " + restrictionName);
            }
            if (propertyName.endsWith("IgnoreCase")) {
                restrictionName = restrictionName + "IgnoreCase";
                propertyName = propertyName.substring("IgnoreCase".length());
            }
            if ((restriction = Restrictions.findPropertyRestriction(restrictionName)) == null) {
                throw new MatchFailedException("Unknown restriction: " + restrictionName);
            }
            return this.getPropertyRestriction(propertyName, root, cb, parameters, restriction);
        }
        matcher = RESTRICTIONS_PATTERN.matcher(expression);
        if (matcher.find()) {
            String restrictionName = matcher.group(1);
            Restrictions.Restriction restriction = Restrictions.findRestriction(restrictionName);
            if (restriction == null) {
                throw new MatchFailedException("Unknown restriction: " + restrictionName);
            }
            return this.getRestriction(root, cb, parameters, restriction);
        }
        String propertyName = expression;
        String restrictionName = "Equals";
        if (propertyName.endsWith("IgnoreCase")) {
            restrictionName = restrictionName + "IgnoreCase";
            propertyName = AbstractCriteriaMethodMatch.extractPropertyName(propertyName, "IgnoreCase");
        }
        Restrictions.PropertyRestriction restriction = Restrictions.findPropertyRestriction(restrictionName);
        return this.getPropertyRestriction(propertyName, root, cb, parameters, restriction);
    }

    private static String extractPropertyName(String queryParameter, String clause) {
        int i;
        String propName = clause != null ? ((i = queryParameter.lastIndexOf(clause)) > -1 ? queryParameter.substring(0, i) : queryParameter) : queryParameter;
        return propName;
    }

    private <T> Predicate getPropertyRestriction(String propertyName, PersistentEntityRoot<T> root, SourcePersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters, Restrictions.PropertyRestriction<?> restriction) {
        boolean negation = false;
        if (propertyName.endsWith(NOT)) {
            int i = propertyName.lastIndexOf(NOT);
            propertyName = propertyName.substring(0, i);
            negation = true;
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            throw new MatchFailedException("No property name specified in clause: " + restriction.getName());
        }
        Expression<?> prop = this.getProperty(root, propertyName);
        Predicate predicate = restriction.find(root, cb, prop, this.provideParams(parameters, restriction.getRequiredParameters(), restriction.getName(), cb, prop).toArray(new ParameterExpression[0]));
        if (negation) {
            predicate = predicate.not();
        }
        return predicate;
    }

    private <T> Predicate getRestriction(PersistentEntityRoot<T> root, SourcePersistentEntityCriteriaBuilder cb, Iterator<ParameterElement> parameters, Restrictions.Restriction<?> restriction) {
        Expression property = null;
        if (restriction.getName().equals("Ids")) {
            property = root.id();
        }
        return restriction.find(root, cb, this.provideParams(parameters, restriction.getRequiredParameters(), restriction.getName(), cb, property).toArray(new ParameterExpression[0]));
    }

    private <T> List<ParameterExpression<T>> provideParams(Iterator<ParameterElement> parameters, int requiredParameters, String restrictionName, SourcePersistentEntityCriteriaBuilder cb, @Nullable Expression<?> expression) {
        if (requiredParameters == 0) {
            return Collections.emptyList();
        }
        ArrayList<ParameterExpression<T>> params = new ArrayList<ParameterExpression<T>>(requiredParameters);
        for (int i = 0; i < requiredParameters; ++i) {
            PersistentPropertyPath pp;
            io.micronaut.data.model.PersistentPropertyPath propertyPath;
            if (!parameters.hasNext()) {
                throw new MatchFailedException("Insufficient arguments to method criteria: " + restrictionName);
            }
            ParameterElement parameter = parameters.next();
            ClassElement genericType = parameter.getGenericType();
            if (TypeUtils.isContainerType(genericType)) {
                genericType = genericType.getFirstTypeArgument().orElse(genericType);
            }
            if (expression instanceof PersistentPropertyPath && !this.isValidType(genericType, (SourcePersistentProperty)(propertyPath = new io.micronaut.data.model.PersistentPropertyPath((pp = (PersistentPropertyPath)expression).getAssociations(), pp.getProperty())).getProperty())) {
                SourcePersistentProperty property = (SourcePersistentProperty)propertyPath.getProperty();
                throw new IllegalArgumentException("Parameter [" + genericType.getType().getName() + " " + parameter.getName() + "] is not compatible with property [" + property.getType().getName() + " " + property.getName() + "] of entity: " + property.getOwner().getName());
            }
            ParameterExpression<Object> p = cb.parameter(parameter);
            params.add(p);
        }
        return params;
    }

    private boolean isValidType(ClassElement genericType, SourcePersistentProperty property) {
        if (TypeUtils.isObjectClass(genericType)) {
            return true;
        }
        PersistentEntity owner = property.getOwner();
        if (TypeUtils.areTypesCompatible(genericType, property.getType()) && !TypeUtils.isObjectClass(genericType)) {
            return true;
        }
        if (owner.hasCompositeIdentity() && property.getOwner().getCompositeIdentity()[0].equals(property)) {
            return true;
        }
        return genericType.isAssignable(Iterable.class);
    }

    protected <T> String applyForUpdate(String querySequence, PersistentEntityCriteriaQuery<T> query) {
        Matcher matcher = FOR_UPDATE_PATTERN.matcher(querySequence);
        if (matcher.matches()) {
            query.forUpdate(true);
            return matcher.group(1);
        }
        return querySequence;
    }

    @NonNull
    protected final <T> Expression<?> getProperty(PersistentEntityRoot<T> root, String propertyName) {
        PersistentPropertyPath<Object> property = this.findProperty(root, propertyName);
        if (property != null) {
            return property;
        }
        if ("id".equals(NameUtils.decapitalize((String)propertyName)) && (root.getPersistentEntity().hasIdentity() || root.getPersistentEntity().hasCompositeIdentity())) {
            return root.id();
        }
        throw new MatchFailedException("Cannot query entity [" + root.getPersistentEntity().getSimpleName() + "] on non-existent property: " + propertyName);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected final <T> PersistentPropertyPath<Object> findProperty(PersistentEntityRoot<T> root, String propertyName) {
        void var7_10;
        io.micronaut.data.model.PersistentPropertyPath pp;
        propertyName = NameUtils.decapitalize((String)propertyName);
        PersistentEntity entity = root.getPersistentEntity();
        PersistentProperty prop = entity.getPropertyByName(propertyName);
        if (prop == null) {
            Optional propertyPath = entity.getPath(propertyName);
            if (!propertyPath.isPresent()) return null;
            String string = (String)propertyPath.get();
            pp = entity.getPropertyPath(string);
            if (pp == null) {
                return null;
            }
        } else {
            pp = new io.micronaut.data.model.PersistentPropertyPath(Collections.emptyList(), prop, propertyName);
        }
        PersistentEntityJoin path = root;
        for (Association association : pp.getAssociations()) {
            path = path.join(association.getName());
        }
        if (pp.getProperty() instanceof Association && ((Association)pp.getProperty()).getKind() != Relation.Kind.EMBEDDED) {
            PersistentEntityJoin persistentEntityJoin = path.join(pp.getProperty().getName());
            return CriteriaUtils.requireProperty((Expression)var7_10);
        } else {
            PersistentPropertyPath persistentPropertyPath = path.get(pp.getProperty().getName());
        }
        return CriteriaUtils.requireProperty((Expression)var7_10);
    }

    protected final void applyJoinSpecs(PersistentEntityRoot<?> root, @NonNull List<AnnotationValue<Join>> joinSpecs) {
        for (AnnotationValue<Join> joinSpec : joinSpecs) {
            String path = joinSpec.stringValue().orElse(null);
            Join.Type type = joinSpec.enumValue("type", Join.Type.class).orElse(Join.Type.FETCH);
            String alias = joinSpec.stringValue("alias").orElse(null);
            if (path == null) continue;
            io.micronaut.data.model.PersistentPropertyPath propertyPath = root.getPersistentEntity().getPropertyPath(path);
            if (propertyPath == null || !(propertyPath.getProperty() instanceof Association)) {
                throw new MatchFailedException("Invalid join spec [" + path + "]. Property is not an association!");
            }
            PersistentEntityJoin p = root;
            for (Association association : propertyPath.getAssociations()) {
                p = p.join(association.getName(), type);
            }
            if (alias != null) {
                p.join(propertyPath.getProperty().getName(), type, alias);
                continue;
            }
            p.join(propertyPath.getProperty().getName(), type);
        }
    }

    @NonNull
    protected final List<AnnotationValue<Join>> joinSpecsAtMatchContext(@NonNull MethodMatchContext matchContext, boolean isQuery) {
        if (!isQuery) {
            return matchContext.getAnnotationMetadata().getDeclaredAnnotationValuesByType(Join.class);
        }
        List joins = matchContext.getAnnotationMetadata().getAnnotationValuesByType(Join.class);
        if (!joins.isEmpty()) {
            return joins;
        }
        return matchContext.getRepositoryClass().getAnnotationMetadata().getAnnotationValuesByType(Join.class);
    }

    protected final boolean hasNoWhereDeclaration(@NonNull MethodMatchContext matchContext) {
        boolean repositoryHasWhere = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass(), matchContext.getMethodElement()}).hasAnnotation(Where.class);
        boolean entityHasWhere = matchContext.getRootEntity().hasAnnotation(Where.class);
        return !repositoryHasWhere && !entityHasWhere;
    }

    static {
        for (int i = 0; i < OPERATORS.length; ++i) {
            AbstractCriteriaMethodMatch.OPERATOR_PATTERNS[i] = Pattern.compile("(\\w+)(" + OPERATORS[i] + ")(\\p{Upper})(\\w+)");
        }
        ArrayList<String> propertyRestrictionElements = new ArrayList<String>(Restrictions.PROPERTY_RESTRICTIONS_MAP.keySet());
        propertyRestrictionElements.sort(Comparator.comparingInt(String::length).thenComparing(String.CASE_INSENSITIVE_ORDER).reversed());
        String prExpressionPattern = String.join((CharSequence)"|", propertyRestrictionElements);
        PROPERTY_RESTRICTIONS_PATTERN = Pattern.compile("\\p{Upper}[\\p{Lower}\\d]+(" + prExpressionPattern + ")");
        ArrayList<String> restrictionElements = new ArrayList<String>(Restrictions.RESTRICTIONS_MAP.keySet());
        restrictionElements.sort(Comparator.comparingInt(String::length).thenComparing(String.CASE_INSENSITIVE_ORDER).reversed());
        String rExpressionPattern = String.join((CharSequence)"|", restrictionElements);
        RESTRICTIONS_PATTERN = Pattern.compile("^(" + rExpressionPattern + ")$");
    }
}

