/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public class CountSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public CountSpecificationMethodMatcher() {
        super("count");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (TypeUtils.isValidCountReturnType(matchContext)) {
            return mc -> {
                if (this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement())) {
                    Map.Entry<ClassElement, ClassElement> e = FindersUtils.pickCountSpecInterceptor(matchContext, matchContext.getReturnType());
                    return new MethodMatchInfo((TypedElement)e.getKey(), e.getValue());
                }
                if (this.isFirstParameterSpringJpaSpecification(mc.getMethodElement())) {
                    return new MethodMatchInfo((TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.spring.jpa.intercept.CountSpecificationInterceptor"));
                }
                return new MethodMatchInfo((TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.jpa.repository.intercept.CountSpecificationInterceptor"));
            };
        }
        return null;
    }

    @Override
    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return super.isMatchesParameters(matchContext) || this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement());
    }
}

