/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public class FindOneSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public FindOneSpecificationMethodMatcher() {
        super("get", "find", "search", "query");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement())) {
            Map.Entry<ClassElement, ClassElement> e = FindersUtils.pickFindOneSpecInterceptor(matchContext, matchContext.getMethodElement().getGenericReturnType());
            return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)e.getKey(), (ClassElement)e.getValue());
        }
        if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
            return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.spring.jpa.intercept.FindOneSpecificationInterceptor"));
        }
        return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.jpa.repository.intercept.FindOneSpecificationInterceptor"));
    }

    @Override
    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return super.isMatchesParameters(matchContext) || this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement());
    }
}

