/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Expandable;
import io.micronaut.data.annotation.JsonRepresentation;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.IParameterExpression;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.ClassElementExpressionType;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
public final class SourceParameterExpressionImpl
extends IParameterExpression<Object>
implements BindingParameter {
    private final Map<String, DataType> dataTypes;
    private final ClassElement expressionType;
    @Nullable
    private final ParameterElement[] parameters;
    private final ParameterElement parameterElement;
    private final boolean isEntityParameter;
    private boolean isUpdate;
    private final PersistentPropertyPath parameterPropertyPath;

    public SourceParameterExpressionImpl(Map<String, DataType> dataTypes, ParameterElement[] parameters, ParameterElement parameterElement, boolean isEntityParameter, PersistentPropertyPath parameterPropertyPath) {
        this(parameterElement == null ? null : parameterElement.getName(), dataTypes, null, parameters, parameterElement, isEntityParameter, false, parameterPropertyPath);
    }

    public SourceParameterExpressionImpl(Map<String, DataType> dataTypes, String name, ClassElement expressionType, PersistentPropertyPath parameterPropertyPath) {
        this(name, dataTypes, expressionType, null, null, false, false, parameterPropertyPath);
    }

    private SourceParameterExpressionImpl(String name, Map<String, DataType> dataTypes, ClassElement expressionType, @Nullable ParameterElement[] parameters, ParameterElement parameterElement, boolean isEntityParameter, boolean isUpdate, PersistentPropertyPath parameterPropertyPath) {
        super(new ClassElementExpressionType(SourceParameterExpressionImpl.getSourceExpressionType(expressionType, parameterElement, parameterPropertyPath)), name);
        this.dataTypes = dataTypes;
        this.expressionType = expressionType;
        this.parameters = parameters;
        this.parameterElement = parameterElement;
        this.isEntityParameter = isEntityParameter;
        this.isUpdate = isUpdate;
        this.parameterPropertyPath = parameterPropertyPath;
    }

    public static ClassElement getSourceExpressionType(ClassElement expressionType, ParameterElement parameterElement, PersistentPropertyPath parameterPropertyPath) {
        if (expressionType != null) {
            return expressionType;
        }
        if (parameterPropertyPath != null) {
            SourcePersistentProperty property = (SourcePersistentProperty)parameterPropertyPath.getProperty();
            return property.getType();
        }
        if (parameterElement != null) {
            return parameterElement.getType();
        }
        return null;
    }

    public Class<Object> getParameterType() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public void setUpdate(boolean update) {
        this.isUpdate = update;
    }

    public QueryParameterBinding bind(BindingParameter.BindingContext bindingContext) {
        String[] parameterBindingPath;
        String[] path;
        PersistentPropertyPath outgoingQueryParameterProperty;
        PersistentPropertyPath propertyPath;
        final String bindName = bindingContext.getName() == null ? String.valueOf(bindingContext.getIndex()) : bindingContext.getName();
        PersistentPropertyPath incomingMethodParameterProperty = bindingContext.getIncomingMethodParameterProperty();
        if (incomingMethodParameterProperty == null) {
            incomingMethodParameterProperty = this.parameterPropertyPath;
        }
        PersistentPropertyPath persistentPropertyPath = propertyPath = (outgoingQueryParameterProperty = bindingContext.getOutgoingQueryParameterProperty()) == null ? incomingMethodParameterProperty : outgoingQueryParameterProperty;
        if (propertyPath == null) {
            if (this.parameterElement != null) {
                final int index = Arrays.asList(this.parameters).indexOf(this.parameterElement);
                final DataType dataType = this.getDataType(null, this.parameterElement, this.expressionType);
                final JsonDataType jsonDataType = dataType == DataType.JSON ? this.getJsonDataType(null, this.parameterElement, this.expressionType) : null;
                final String converter = this.parameterElement.stringValue(TypeDef.class, "converter").orElse(null);
                final boolean isExpandable = this.isExpandable(bindingContext, dataType);
                return new QueryParameterBinding(){

                    public String getName() {
                        return SourceParameterExpressionImpl.this.getName();
                    }

                    public String getKey() {
                        return bindName;
                    }

                    public int getParameterIndex() {
                        return index;
                    }

                    public DataType getDataType() {
                        return dataType;
                    }

                    public JsonDataType getJsonDataType() {
                        return jsonDataType;
                    }

                    public String getConverterClassName() {
                        return converter;
                    }

                    public boolean isExpandable() {
                        return isExpandable;
                    }
                };
            }
            Objects.requireNonNull(this.expressionType);
            final DataType dataType = this.getDataType(null, null, this.expressionType);
            final JsonDataType jsonDataType = dataType == DataType.JSON ? this.getJsonDataType(null, null, this.expressionType) : null;
            final boolean isExpandable = this.isExpandable(bindingContext, dataType);
            return new QueryParameterBinding(){

                public String getName() {
                    return SourceParameterExpressionImpl.this.getName();
                }

                public String getKey() {
                    return bindName;
                }

                public DataType getDataType() {
                    return dataType;
                }

                public JsonDataType getJsonDataType() {
                    return jsonDataType;
                }

                public boolean isExpandable() {
                    return isExpandable;
                }

                public boolean isExpression() {
                    return true;
                }
            };
        }
        final boolean autopopulated = propertyPath.getProperty().findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false);
        final DataType dataType = this.getDataType(propertyPath, this.parameterElement, this.expressionType);
        final JsonDataType jsonDataType = this.getJsonDataType(propertyPath, this.parameterElement, this.expressionType);
        final String converterClassName = ((SourcePersistentProperty)propertyPath.getProperty()).getConverterClassName();
        final int index = this.parameterElement == null || this.isEntityParameter ? -1 : Arrays.asList(this.parameters).indexOf(this.parameterElement);
        final boolean requiresPrevValue = index == -1 && autopopulated && !this.isUpdate;
        final boolean isExpandable = this.isExpandable(bindingContext, dataType);
        if (outgoingQueryParameterProperty != null) {
            path = outgoingQueryParameterProperty.getArrayPath();
            parameterBindingPath = index != -1 ? this.getBindingPath(incomingMethodParameterProperty, outgoingQueryParameterProperty) : null;
        } else {
            path = null;
            parameterBindingPath = null;
        }
        return new QueryParameterBinding(){

            public String getName() {
                return SourceParameterExpressionImpl.this.getName();
            }

            public String getKey() {
                return bindName;
            }

            public DataType getDataType() {
                return dataType;
            }

            public JsonDataType getJsonDataType() {
                return jsonDataType;
            }

            public String getConverterClassName() {
                return converterClassName;
            }

            public int getParameterIndex() {
                return index;
            }

            public String[] getParameterBindingPath() {
                return parameterBindingPath;
            }

            public String[] getPropertyPath() {
                return path;
            }

            public boolean isAutoPopulated() {
                return autopopulated;
            }

            public boolean isRequiresPreviousPopulatedValue() {
                return requiresPrevValue;
            }

            public boolean isExpandable() {
                return isExpandable;
            }

            public boolean isExpression() {
                return SourceParameterExpressionImpl.this.expressionType != null;
            }
        };
    }

    private boolean isExpandable(BindingParameter.BindingContext bindingContext, DataType dataType) {
        if (bindingContext.isExpandable()) {
            return true;
        }
        if (this.parameterElement != null && this.parameterElement.isAnnotationPresent(Expandable.class)) {
            return true;
        }
        if (dataType == DataType.JSON) {
            return false;
        }
        return !dataType.isArray() && this.parameterElement != null && this.parameterElement.getType().isAssignable(Iterable.class.getName());
    }

    private String[] getBindingPath(PersistentPropertyPath parameterProperty, PersistentPropertyPath bindedPath) {
        String p;
        String pp;
        if (parameterProperty == null) {
            return bindedPath.getArrayPath();
        }
        List<String> parameterPath = List.of(parameterProperty.getArrayPath());
        List<String> path = List.of(bindedPath.getArrayPath());
        if (path.equals(parameterPath)) {
            return null;
        }
        int fromIndex = 0;
        for (int i = 0; i < path.size() && i < parameterPath.size() && (pp = parameterPath.get(i)).equals(p = path.get(i)); ++i) {
            ++fromIndex;
        }
        return path.subList(fromIndex, path.size()).toArray(new String[0]);
    }

    private DataType getDataType(PersistentPropertyPath propertyPath, ParameterElement parameterElement, ClassElement type) {
        PersistentProperty property;
        if (propertyPath != null && !((property = propertyPath.getProperty()) instanceof Association)) {
            return property.getDataType();
        }
        if (parameterElement != null) {
            DataType dataType = TypeUtils.resolveDataType(parameterElement).orElse(null);
            if (dataType != null) {
                return dataType;
            }
            if (type == null) {
                type = parameterElement.getType();
            }
        }
        if (type != null) {
            if (TypeUtils.isContainerType(type)) {
                type = type.getFirstTypeArgument().orElse(type);
            }
            return TypeUtils.resolveDataType(type, this.dataTypes);
        }
        return DataType.OBJECT;
    }

    private JsonDataType getJsonDataType(PersistentPropertyPath propertyPath, ParameterElement parameterElement, ClassElement type) {
        JsonDataType jsonDataType;
        PersistentProperty property;
        if (propertyPath != null && !((property = propertyPath.getProperty()) instanceof Association) && (jsonDataType = property.getJsonDataType()) != null) {
            return jsonDataType;
        }
        Object element = type == null && parameterElement != null ? parameterElement : type;
        if (element != null) {
            return element.enumValue(JsonRepresentation.class, "type", JsonDataType.class).orElse(JsonDataType.DEFAULT);
        }
        return JsonDataType.DEFAULT;
    }
}

