/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.UpdateCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

@Internal
public final class UpdateMethodMatcher
extends AbstractMethodMatcher {
    public UpdateMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "update", "modify").tryMatch(QueryMatchId.ALL_OR_ONE, ALL_OR_ONE).tryMatchLastOccurrencePrefixed(QueryMatchId.RETURNING, null, "Returning").tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").build());
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        ParameterElement idParameter;
        MethodElement methodElement = matchContext.getMethodElement();
        ParameterElement[] parameters = methodElement.getParameters();
        boolean isReturning = matches.stream().anyMatch(m -> m.id() == QueryMatchId.RETURNING);
        if (parameters.length > 1 && (idParameter = (ParameterElement)Arrays.stream(parameters).filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null)) != null) {
            if (!isReturning && !TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
                throw new MatchFailedException("Update methods only support void or number based return types");
            }
            return this.batchUpdate(matches, isReturning);
        }
        ParameterElement entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
        ParameterElement entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
        if (entityParameter != null || entitiesParameter != null) {
            return this.entityUpdate(matches, entityParameter, entitiesParameter, isReturning);
        }
        if (!isReturning && !TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
            throw new MatchFailedException("Update methods only support void or number based return types");
        }
        return this.batchUpdateBy(matches, isReturning);
    }

    private UpdateCriteriaMethodMatch entityUpdate(List<MethodNameParser.Match> matches, final ParameterElement entityParameter, final ParameterElement entitiesParameter, final boolean isReturning) {
        return new UpdateCriteriaMethodMatch(matches, isReturning){
            final ParameterElement entityParam;
            {
                super(matches, isReturning2);
                this.entityParam = entityParameter == null ? entitiesParameter : entityParameter;
            }

            @Override
            protected <T> void addPropertiesToUpdate(List<ParameterElement> nonConsumedParameters, MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                if (DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)matchContext.getAnnotationMetadata())) {
                    AnnotationValue entityRepresentationAnnotationValue = rootEntity.getAnnotationMetadata().getAnnotation(EntityRepresentation.class);
                    String columnName = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
                    query.set(columnName, cb.parameter(entityParameter, null));
                    return;
                }
                Stream.concat(rootEntity.getPersistentProperties().stream(), Stream.of(rootEntity.getVersion())).filter(p -> {
                    Association association;
                    return p != null && (!(p instanceof Association) || !(association = (Association)p).isForeignKey()) && !p.isGenerated() && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(true) != false;
                }).forEach(p -> query.set(p.getName(), cb.entityPropertyParameter(this.entityParam, new io.micronaut.data.model.PersistentPropertyPath((PersistentProperty)p))));
                if (((AbstractPersistentEntityCriteriaUpdate)query).getUpdateValues().isEmpty()) {
                    query.set(rootEntity.getIdentity().getName(), cb.entityPropertyParameter(this.entityParam, new io.micronaut.data.model.PersistentPropertyPath((PersistentProperty)rootEntity.getIdentity())));
                }
            }

            @Override
            protected boolean supportedByImplicitQueries() {
                return true;
            }

            @Override
            protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                MethodElement methodElement = matchContext.getMethodElement();
                FindersUtils.InterceptorMatch e = super.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement returnType = e.returnType();
                if (!(isReturning || returnType == null || TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType) || returnType.hasStereotype(MappedEntity.class) || TypeUtils.isReactiveOrFuture(matchContext.getReturnType()) && TypeUtils.isObjectClass(returnType))) {
                    throw new MatchFailedException("Cannot implement update method for specified return type: " + returnType.getName() + " " + String.valueOf(methodElement.getReturnType()) + " " + methodElement.getDescription(false));
                }
                return e;
            }

            @Override
            protected ParameterElement getEntityParameter() {
                return entityParameter;
            }

            @Override
            protected ParameterElement getEntitiesParameter() {
                return entitiesParameter;
            }
        };
    }

    private UpdateCriteriaMethodMatch batchUpdate(List<MethodNameParser.Match> matches, boolean isReturning) {
        return new UpdateCriteriaMethodMatch(matches, isReturning){

            @Override
            protected <T> void addPropertiesToUpdate(List<ParameterElement> nonConsumedParameters, MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                List<ParameterElement> parameters = matchContext.getParametersNotInRole();
                ParameterElement idParameter = parameters.stream().filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
                if (idParameter == null) {
                    throw new MatchFailedException("ID required for update method, but not specified");
                }
                SourcePersistentEntity entity = (SourcePersistentEntity)root.getPersistentEntity();
                if (entity.hasIdentity()) {
                    String idParameterType;
                    SourcePersistentProperty identity = entity.getIdentity();
                    String idType = TypeUtils.getTypeName(identity.getType());
                    if (!idType.equals(idParameterType = TypeUtils.getTypeName(idParameter.getType()))) {
                        throw new MatchFailedException("ID type of method [" + idParameterType + "] does not match ID type of entity: " + idType);
                    }
                } else {
                    throw new MatchFailedException("Cannot update by ID for entity that has no ID");
                }
                for (ParameterElement parameter : nonConsumedParameters) {
                    String name = UpdateMethodMatcher.this.getParameterName(parameter);
                    SourcePersistentProperty prop = entity.getPropertyByName(name);
                    if (prop == null) {
                        throw new MatchFailedException("Cannot update non-existent property: " + name);
                    }
                    if (prop.isGenerated()) {
                        throw new MatchFailedException("Cannot update a generated property: " + name);
                    }
                    query.set(name, cb.parameter(parameter, new io.micronaut.data.model.PersistentPropertyPath((PersistentProperty)prop)));
                }
            }
        };
    }

    private UpdateCriteriaMethodMatch batchUpdateBy(List<MethodNameParser.Match> matches, boolean isReturning) {
        return new UpdateCriteriaMethodMatch(matches, isReturning){

            @Override
            protected <T> void addPropertiesToUpdate(List<ParameterElement> nonConsumedParameters, MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                for (ParameterElement p : nonConsumedParameters) {
                    String parameterName = UpdateMethodMatcher.this.getParameterName(p);
                    PersistentEntity persistentEntity = root.getPersistentEntity();
                    io.micronaut.data.model.PersistentPropertyPath path = persistentEntity.getPropertyPath(persistentEntity.getPath(parameterName).orElse(parameterName));
                    if (path != null) {
                        PersistentProperty property = path.getProperty();
                        if (path.getAssociations().isEmpty()) {
                            query.set(property.getName(), cb.parameter(p, path));
                            continue;
                        }
                        Association association = (Association)path.getAssociations().get(0);
                        if (path.getAssociations().size() == 1 && PersistentEntityUtils.isAccessibleWithoutJoin((Association)association, (PersistentProperty)property)) {
                            PersistentPropertyPath pp = root.join(association.getName()).get(property.getName());
                            ParameterExpression parameter = cb.parameter(p, path);
                            query.set((Path)pp, parameter);
                            continue;
                        }
                        throw new MatchFailedException("Cannot perform batch update for a property with an association: " + parameterName);
                    }
                    throw new MatchFailedException("Cannot perform batch update for non-existent property: " + parameterName);
                }
            }
        };
    }

    private String getParameterName(ParameterElement p) {
        return p.stringValue(Parameter.class).orElse(p.getName());
    }
}

