/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Internal
public class SourcePersistentProperty
implements PersistentProperty,
TypedElement {
    private final SourcePersistentEntity owner;
    private final PropertyElement propertyElement;
    private final DataType dataType;
    private final ClassElement type;
    private final String converterClassName;
    private final String alias;

    SourcePersistentProperty(SourcePersistentEntity owner, PropertyElement propertyElement) {
        this.owner = owner;
        this.propertyElement = propertyElement;
        this.type = propertyElement.getGenericType();
        this.dataType = this.computeDataType(propertyElement);
        this.converterClassName = propertyElement.stringValue(MappedProperty.class, "converter").orElse(null);
        this.alias = this.getAnnotationMetadata().stringValue(MappedProperty.class, "alias").orElse("");
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isOptional() {
        return this.propertyElement.isNullable();
    }

    private DataType computeDataType(PropertyElement propertyElement) {
        if (this instanceof Association) {
            return DataType.ENTITY;
        }
        AnnotationMetadata annotationMetadata = propertyElement.getAnnotationMetadata();
        return annotationMetadata.enumValue(MappedProperty.class, "type", DataType.class).orElseGet(() -> {
            DataType dt = annotationMetadata.getValue(TypeDef.class, "type", DataType.class).orElse(null);
            if (dt != null) {
                return dt;
            }
            if (this.isEnum()) {
                return DataType.STRING;
            }
            return TypeUtils.resolveDataType(this.type, Collections.emptyMap());
        });
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public List<PersistentProperty.EnumConstant> getEnumConstants() {
        ClassElement classElement = this.type;
        if (classElement instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)classElement;
            ArrayList<PersistentProperty.EnumConstant> list = new ArrayList<PersistentProperty.EnumConstant>();
            int i = 0;
            for (final EnumConstantElement e : enumElement.elements()) {
                final int finalI = i++;
                PersistentProperty.EnumConstant enumConstant = new PersistentProperty.EnumConstant(){

                    public String name() {
                        return e.getName();
                    }

                    public int ordinal() {
                        return finalI;
                    }
                };
                list.add(enumConstant);
            }
            return list;
        }
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourcePersistentProperty that = (SourcePersistentProperty)o;
        return this.owner.equals((Object)that.owner) && this.propertyElement.getName().equals(that.propertyElement.getName());
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.owner, this.propertyElement.getName()});
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.propertyElement.getAnnotationMetadata();
    }

    @NonNull
    public String getName() {
        return this.propertyElement.getName();
    }

    public boolean isProtected() {
        return this.propertyElement.isProtected();
    }

    public boolean isPublic() {
        return this.propertyElement.isPublic();
    }

    public Object getNativeType() {
        return this.propertyElement.getNativeType();
    }

    @NonNull
    public String getTypeName() {
        return this.type.getName();
    }

    @NonNull
    public PersistentEntity getOwner() {
        return this.owner;
    }

    public boolean isAssignable(@NonNull String type) {
        ClassElement t = this.getType();
        return t.isAssignable(type);
    }

    @NonNull
    public PropertyElement getPropertyElement() {
        return this.propertyElement;
    }

    @NonNull
    public ClassElement getType() {
        return this.type;
    }

    @NonNull
    public String getPersistedName() {
        return this.owner.getNamingStrategy().mappedName((PersistentProperty)this);
    }

    @Nullable
    public String getConverterClassName() {
        return this.converterClassName;
    }

    public String toString() {
        return this.getOwner().getName() + "(" + this.getTypeName() + " " + this.getName() + ")";
    }
}

