/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.SaveAllInterceptor;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;

public class DefaultSaveAllInterceptor<T, R>
extends AbstractQueryInterceptor<T, Iterable<R>>
implements SaveAllInterceptor<T, R> {
    public DefaultSaveAllInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Iterable<R> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Iterable<R>> context) {
        Object[] parameterValues = context.getParameterValues();
        if (ArrayUtils.isNotEmpty((Object[])parameterValues) && parameterValues[0] instanceof Iterable) {
            Iterable iterable = (Iterable)parameterValues[0];
            Iterable rs = this.operations.persistAll(this.getInsertBatchOperation(context, iterable));
            ReturnType rt = context.getReturnType();
            if (!rt.getType().isInstance(rs)) {
                return (Iterable)ConversionService.SHARED.convert((Object)rs, rt.asArgument()).orElseThrow(() -> new IllegalStateException("Unsupported iterable return type: " + rs.getClass()));
            }
            return rs;
        }
        throw new IllegalArgumentException("First argument should be an iterable");
    }
}

