/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper.sql;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.http.codec.MediaTypeCodec;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.validation.constraints.NotNull;

@Internal
public final class SqlResultEntityTypeMapper<RS, R>
implements SqlTypeMapper<RS, R> {
    private final RuntimePersistentEntity<R> entity;
    private final ResultReader<RS, String> resultReader;
    private final Map<String, JoinPath> joinPaths;
    private final String startingPrefix;
    private final MediaTypeCodec jsonCodec;
    private final BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener;
    private boolean callNext = true;

    public SqlResultEntityTypeMapper(String prefix, @NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable MediaTypeCodec jsonCodec) {
        this(entity, resultReader, Collections.emptySet(), prefix, jsonCodec, null);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, @Nullable MediaTypeCodec jsonCodec) {
        this(entity, resultReader, joinPaths, null, jsonCodec, null);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, @Nullable MediaTypeCodec jsonCodec, @Nullable BiFunction<RuntimePersistentEntity<Object>, Object, Object> loadListener) {
        this(entity, resultReader, joinPaths, null, jsonCodec, loadListener);
    }

    private SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, String startingPrefix, @Nullable MediaTypeCodec jsonCodec, @Nullable BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener) {
        ArgumentUtils.requireNonNull((String)"entity", entity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.entity = entity;
        this.jsonCodec = jsonCodec;
        this.resultReader = resultReader;
        this.eventListener = eventListener;
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            this.joinPaths = new HashMap<String, JoinPath>(joinPaths.size());
            for (JoinPath joinPath : joinPaths) {
                this.joinPaths.put(joinPath.getPath(), joinPath);
            }
        } else {
            this.joinPaths = Collections.emptyMap();
        }
        this.startingPrefix = startingPrefix;
    }

    @NonNull
    public RuntimePersistentEntity<R> getEntity() {
        return this.entity;
    }

    @NonNull
    public ResultReader<RS, String> getResultReader() {
        return this.resultReader;
    }

    @Override
    @NonNull
    public R map(@NonNull RS rs, @NonNull Class<R> type) throws DataAccessException {
        R entityInstance = this.readEntity(rs, MappingContext.of(this.entity, this.startingPrefix), null, null);
        if (entityInstance == null) {
            throw new DataAccessException("Unable to map result to entity of type [" + type.getName() + "]. Missing result data.");
        }
        return this.triggerPostLoad(this.entity, entityInstance);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull String name) {
        RuntimePersistentProperty property = this.entity.getPropertyByName(name);
        if (property == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.entity.getName());
        }
        DataType dataType = property.getDataType();
        String columnName = property.getPersistedName();
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull Argument<?> argument) {
        String columnName;
        DataType dataType;
        RuntimePersistentProperty property = this.entity.getPropertyByName(argument.getName());
        if (property == null) {
            dataType = argument.getAnnotationMetadata().enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> DataType.forType((Class)argument.getType()));
            columnName = argument.getName();
        } else {
            dataType = property.getDataType();
            columnName = property.getPersistedName();
        }
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    public boolean hasNext(RS resultSet) {
        if (this.callNext) {
            return this.resultReader.next(resultSet);
        }
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            this.callNext = true;
        }
    }

    public PushingMapper<RS, R> readOneWithJoins() {
        return new PushingMapper<RS, R>(){
            final MappingContext<R> ctx;
            R entityInstance;
            {
                this.ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
            }

            @Override
            public void processRow(RS row) {
                if (this.entityInstance == null) {
                    Object id = SqlResultEntityTypeMapper.this.readEntityId(row, this.ctx);
                    this.entityInstance = SqlResultEntityTypeMapper.this.readEntity(row, this.ctx, null, id);
                } else {
                    SqlResultEntityTypeMapper.this.readChildren(row, this.entityInstance, null, this.ctx);
                }
            }

            @Override
            public R getResult() {
                if (this.entityInstance == null) {
                    return null;
                }
                if (SqlResultEntityTypeMapper.this.joinPaths.isEmpty()) {
                    return SqlResultEntityTypeMapper.this.triggerPostLoad(SqlResultEntityTypeMapper.this.entity, this.entityInstance);
                }
                this.entityInstance = SqlResultEntityTypeMapper.this.setChildrenAndTriggerPostLoad(this.entityInstance, this.ctx);
                return this.entityInstance;
            }
        };
    }

    public PushingMapper<RS, List<R>> readAllWithJoins() {
        return new PushingMapper<RS, List<R>>(){
            final Map<Object, MappingContext<R>> processed = new LinkedHashMap();

            @Override
            public void processRow(RS row) {
                MappingContext ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
                Object id = SqlResultEntityTypeMapper.this.readEntityId(row, ctx);
                if (id == null) {
                    throw new IllegalStateException("Entity doesn't have an id!");
                }
                MappingContext prevCtx = this.processed.get(id);
                if (prevCtx != null) {
                    SqlResultEntityTypeMapper.this.readChildren(row, prevCtx.entity, null, prevCtx);
                } else {
                    ctx.entity = SqlResultEntityTypeMapper.this.readEntity(row, ctx, null, id);
                    this.processed.put(id, ctx);
                }
            }

            @Override
            public List<R> getResult() {
                ArrayList<Object> values = new ArrayList<Object>(this.processed.size());
                for (Map.Entry e : this.processed.entrySet()) {
                    MappingContext ctx = e.getValue();
                    Object entityInstance = SqlResultEntityTypeMapper.this.setChildrenAndTriggerPostLoad(ctx.entity, ctx);
                    values.add(entityInstance);
                }
                return values;
            }
        };
    }

    private void readChildren(RS rs, Object instance, Object parent, MappingContext<R> ctx) {
        if (((MappingContext)ctx).manyAssociations != null) {
            Object id = this.readEntityId(rs, ctx);
            MappingContext associatedCtx = (MappingContext)((MappingContext)ctx).manyAssociations.get(id);
            if (associatedCtx == null) {
                associatedCtx = ((MappingContext)ctx).copy();
                Object entity = this.readEntity(rs, associatedCtx, parent, id);
                ctx.associate(associatedCtx, id, entity);
            } else {
                this.readChildren(rs, instance, parent, associatedCtx);
            }
            return;
        }
        if (((MappingContext)ctx).associations != null) {
            for (Map.Entry e : ((MappingContext)ctx).associations.entrySet()) {
                MappingContext associationCtx = (MappingContext)e.getValue();
                RuntimeAssociation runtimeAssociation = (RuntimeAssociation)e.getKey();
                Object in = instance == null || !runtimeAssociation.getKind().isSingleEnded() ? null : runtimeAssociation.getProperty().get(instance);
                this.readChildren(rs, in, instance, associationCtx);
            }
        }
    }

    private Object setChildrenAndTriggerPostLoad(Object instance, MappingContext<?> ctx) {
        if (((MappingContext)ctx).manyAssociations != null) {
            ArrayList<Object> values = new ArrayList<Object>(((MappingContext)ctx).manyAssociations.size());
            for (MappingContext associationCtx : ((MappingContext)ctx).manyAssociations.values()) {
                values.add(this.setChildrenAndTriggerPostLoad(associationCtx.entity, associationCtx));
            }
            return values;
        }
        if (((MappingContext)ctx).associations != null) {
            for (Map.Entry e : ((MappingContext)ctx).associations.entrySet()) {
                MappingContext associationCtx = (MappingContext)e.getValue();
                RuntimeAssociation runtimeAssociation = (RuntimeAssociation)e.getKey();
                BeanProperty beanProperty = runtimeAssociation.getProperty();
                if (runtimeAssociation.getKind().isSingleEnded() && (associationCtx.manyAssociations == null || associationCtx.manyAssociations.isEmpty())) {
                    Object value = beanProperty.get(instance);
                    Object newValue = this.setChildrenAndTriggerPostLoad(value, associationCtx);
                    if (newValue == value) continue;
                    instance = this.setProperty(beanProperty, instance, newValue);
                    continue;
                }
                Object newValue = this.setChildrenAndTriggerPostLoad(null, associationCtx);
                if (newValue == null) continue;
                newValue = this.resultReader.convertRequired(newValue, beanProperty.getType());
                instance = this.setProperty(beanProperty, instance, newValue);
            }
        }
        if (instance != null && (((MappingContext)ctx).association == null || ((MappingContext)ctx).jp != null)) {
            this.triggerPostLoad(((MappingContext)ctx).persistentEntity, instance);
        }
        return instance;
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    @Nullable
    private <K> K readEntity(RS rs, MappingContext<K> ctx, @Nullable Object parent, @Nullable Object resolveId) {
        RuntimePersistentEntity persistentEntity = ((MappingContext)ctx).persistentEntity;
        BeanIntrospection introspection = persistentEntity.getIntrospection();
        Object[] constructorArguments = persistentEntity.getConstructorArguments();
        try {
            Object v;
            RuntimePersistentProperty version;
            Object v2;
            RuntimeAssociation entityAssociation;
            Object entity;
            Object id;
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            boolean isAssociation = ((MappingContext)ctx).association != null;
            boolean isEmbedded = ((MappingContext)ctx).association instanceof Embedded;
            boolean nullableEmbedded = isEmbedded && ((MappingContext)ctx).association.isOptional();
            Object object = id = resolveId == null ? this.readEntityId(rs, ctx) : resolveId;
            if (id == null && !isEmbedded && isAssociation) {
                return null;
            }
            if (ArrayUtils.isEmpty((Object[])constructorArguments)) {
                entity = introspection.instantiate();
            } else {
                int len = constructorArguments.length;
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object prop = constructorArguments[i];
                    if (prop != null) {
                        if (prop instanceof Association) {
                            boolean isInverse;
                            entityAssociation = (RuntimeAssociation)prop;
                            if (prop instanceof Embedded) {
                                args[i] = this.readEntity(rs, ctx.embedded((Embedded)prop), null, null);
                                continue;
                            }
                            Relation.Kind kind = entityAssociation.getKind();
                            boolean bl = isInverse = parent != null && isAssociation && ((MappingContext)ctx).association.getOwner() == entityAssociation.getAssociatedEntity();
                            if (isInverse && kind.isSingleEnded()) {
                                args[i] = parent;
                                continue;
                            }
                            MappingContext joinCtx = ctx.join(this.joinPaths, (Association)entityAssociation);
                            Object resolvedId = null;
                            if (!entityAssociation.isForeignKey()) {
                                resolvedId = this.readEntityId(rs, ctx.path((Association)entityAssociation));
                            }
                            if (kind.isSingleEnded()) {
                                if (joinCtx.jp == null || resolvedId == null && !entityAssociation.isForeignKey()) {
                                    args[i] = this.buildIdOnlyEntity(rs, ctx.path((Association)entityAssociation), resolvedId);
                                    continue;
                                }
                                args[i] = this.readEntity(rs, joinCtx, null, resolvedId);
                                continue;
                            }
                            if (!entityAssociation.getProperty().isReadOnly()) continue;
                            args[i] = ConversionService.SHARED.convertRequired(new ArrayList(0), entityAssociation.getProperty().getType());
                            if (joinCtx.jp == null) continue;
                            MappingContext associatedCtx = joinCtx.copy();
                            if (resolvedId == null) {
                                resolvedId = this.readEntityId(rs, associatedCtx);
                            }
                            Object associatedEntity = null;
                            if (resolvedId != null || entityAssociation.isForeignKey()) {
                                associatedEntity = this.readEntity(rs, associatedCtx, null, resolvedId);
                            }
                            if (associatedEntity == null) continue;
                            joinCtx.associate(associatedCtx, resolvedId, associatedEntity);
                            continue;
                        }
                        if (resolveId != null && prop.equals(identity)) {
                            v2 = resolveId;
                        } else {
                            v2 = this.readProperty(rs, ctx, (RuntimePersistentProperty<K>)prop);
                            if (v2 == null) {
                                if (!prop.isOptional() && !nullableEmbedded) {
                                    throw new DataAccessException("Null value read for non-null constructor argument [" + prop.getName() + "] of type: " + persistentEntity.getName());
                                }
                                args[i] = null;
                                continue;
                            }
                        }
                        Class t = prop.getType();
                        args[i] = t.isInstance(v2) ? v2 : this.resultReader.convertRequired(v2, t);
                        continue;
                    }
                    throw new DataAccessException("Constructor argument [" + constructorArguments[i].getName() + "] must have an associated getter.");
                }
                if (nullableEmbedded && args.length > 0 && Arrays.stream(args).allMatch(Objects::isNull)) {
                    return null;
                }
                entity = introspection.instantiate(args);
            }
            if (id != null && identity != null) {
                BeanProperty idProperty = identity.getProperty();
                entity = this.convertAndSetWithValue(entity, identity, idProperty, id, identity.getDataType());
            }
            if ((version = persistentEntity.getVersion()) != null && (v = this.readProperty(rs, ctx, version)) != null) {
                entity = this.convertAndSetWithValue(entity, version, version.getProperty(), v, version.getDataType());
            }
            for (RuntimePersistentProperty rpp : persistentEntity.getPersistentProperties()) {
                Association a;
                Relation.Kind kind;
                if (rpp.isReadOnly() || rpp.isConstructorArgument() && (!(rpp instanceof Association) || (kind = (a = (Association)rpp).getKind()).isSingleEnded())) continue;
                BeanProperty property = rpp.getProperty();
                if (rpp instanceof Association) {
                    boolean isInverse;
                    entityAssociation = (Association)rpp;
                    if (rpp instanceof Embedded) {
                        Object value = this.readEntity(rs, ctx.embedded((Embedded)rpp), parent == null ? entity : parent, null);
                        entity = this.setProperty(property, entity, value);
                        continue;
                    }
                    boolean bl = isInverse = parent != null && entityAssociation.getKind().isSingleEnded() && isAssociation && ((MappingContext)ctx).association.getOwner() == entityAssociation.getAssociatedEntity();
                    if (isInverse) {
                        entity = this.setProperty(property, entity, parent);
                        continue;
                    }
                    MappingContext joinCtx = ctx.join(this.joinPaths, (Association)entityAssociation);
                    Object associatedId = null;
                    if (!entityAssociation.isForeignKey() && (associatedId = this.readEntityId(rs, ctx.path((Association)entityAssociation))) == null) continue;
                    if (joinCtx.jp != null) {
                        K associatedEntity;
                        if (entityAssociation.getKind().isSingleEnded()) {
                            Object associatedEntity2 = this.readEntity(rs, joinCtx, entity, associatedId);
                            entity = this.setProperty(property, entity, associatedEntity2);
                            continue;
                        }
                        MappingContext associatedCtx = joinCtx.copy();
                        if (associatedId == null) {
                            associatedId = this.readEntityId(rs, associatedCtx);
                        }
                        if ((associatedEntity = this.readEntity(rs, associatedCtx, entity, associatedId)) == null) continue;
                        joinCtx.associate(associatedCtx, associatedId, associatedEntity);
                        continue;
                    }
                    if (!entityAssociation.getKind().isSingleEnded() || entityAssociation.isForeignKey()) continue;
                    Object value = this.buildIdOnlyEntity(rs, ctx.path((Association)entityAssociation), associatedId);
                    entity = this.setProperty(property, entity, value);
                    continue;
                }
                v2 = this.readProperty(rs, ctx, rpp);
                if (v2 == null) continue;
                entity = this.convertAndSetWithValue(entity, rpp, property, v2, rpp.getDataType());
            }
            return (K)entity;
        }
        catch (InstantiationException e) {
            throw new DataAccessException("Error instantiating entity [" + persistentEntity.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private <K> Object readProperty(RS rs, MappingContext<K> ctx, RuntimePersistentProperty<K> prop) {
        String columnName = ((MappingContext)ctx).namingStrategy.mappedName(((MappingContext)ctx).embeddedPath, prop);
        if (((MappingContext)ctx).prefix != null && ((MappingContext)ctx).prefix.length() != 0) {
            columnName = ((MappingContext)ctx).prefix + columnName;
        }
        return this.resultReader.readDynamic(rs, columnName, prop.getDataType());
    }

    private <K> K triggerPostLoad(RuntimePersistentEntity<?> persistentEntity, K entity) {
        Object finalEntity = this.eventListener != null && persistentEntity.hasPostLoadEventListeners() ? this.eventListener.apply(persistentEntity, entity) : entity;
        return finalEntity;
    }

    @Nullable
    private <K> Object readEntityId(RS rs, MappingContext<K> ctx) {
        RuntimePersistentProperty identity = ((MappingContext)ctx).persistentEntity.getIdentity();
        if (identity == null) {
            return null;
        }
        if (identity instanceof Embedded) {
            return this.readEntity(rs, ctx.embedded((Embedded)identity), null, null);
        }
        return this.readProperty(rs, ctx, identity);
    }

    private Object convertAndSetWithValue(Object entity, RuntimePersistentProperty rpp, BeanProperty property, Object v, DataType dataType) {
        Class propertyType = rpp.getType();
        if (v instanceof Array) {
            try {
                v = ((Array)v).getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error getting an array value: " + e.getMessage(), (Throwable)e);
            }
        }
        Object r = propertyType.isInstance(v) ? v : (dataType == DataType.JSON && this.jsonCodec != null ? this.jsonCodec.decode(rpp.getArgument(), v.toString()) : this.resultReader.convertRequired(v, rpp.getArgument()));
        return this.setProperty(property, entity, r);
    }

    private <K> K buildIdOnlyEntity(RS rs, MappingContext<K> ctx, Object resolvedId) {
        RuntimePersistentProperty identity = ((MappingContext)ctx).persistentEntity.getIdentity();
        if (identity != null) {
            Argument arg;
            BeanIntrospection associatedIntrospection = ((MappingContext)ctx).persistentEntity.getIntrospection();
            Argument[] constructorArgs = associatedIntrospection.getConstructorArguments();
            if (constructorArgs.length == 0) {
                Object associated = associatedIntrospection.instantiate();
                if (resolvedId == null) {
                    resolvedId = this.readEntityId(rs, ctx);
                }
                BeanWrapper.getWrapper((Object)associated).setProperty(identity.getName(), resolvedId);
                return (K)associated;
            }
            if (constructorArgs.length == 1 && (arg = constructorArgs[0]).getName().equals(identity.getName()) && arg.getType() == identity.getType()) {
                if (resolvedId == null) {
                    resolvedId = this.readEntityId(rs, ctx);
                }
                return (K)associatedIntrospection.instantiate(new Object[]{this.resultReader.convertRequired(resolvedId, identity.getType())});
            }
        }
        return null;
    }

    public RuntimePersistentEntity<R> getPersistentEntity() {
        return this.entity;
    }

    public static interface PushingMapper<RS, R> {
        public void processRow(RS var1);

        public R getResult();
    }

    private static final class MappingContext<E> {
        private final RuntimePersistentEntity<E> rootPersistentEntity;
        private final RuntimePersistentEntity<E> persistentEntity;
        private final NamingStrategy namingStrategy;
        private final String prefix;
        private final JoinPath jp;
        private final List<Association> joinPath;
        private final List<Association> embeddedPath;
        private final Association association;
        private Map<Object, MappingContext> manyAssociations;
        private Map<Association, MappingContext> associations;
        private E entity;

        private MappingContext(RuntimePersistentEntity rootPersistentEntity, RuntimePersistentEntity persistentEntity, NamingStrategy namingStrategy, String prefix, JoinPath jp, List<Association> joinPath, List<Association> embeddedPath, Association association) {
            this.rootPersistentEntity = rootPersistentEntity;
            this.persistentEntity = persistentEntity;
            this.namingStrategy = namingStrategy;
            this.prefix = prefix;
            this.jp = jp;
            this.joinPath = joinPath;
            this.embeddedPath = embeddedPath;
            this.association = association;
        }

        public static <K> MappingContext<K> of(RuntimePersistentEntity<K> persistentEntity, String prefix) {
            return new MappingContext(persistentEntity, persistentEntity, persistentEntity.getNamingStrategy(), prefix, null, Collections.emptyList(), Collections.emptyList(), null);
        }

        public <K> MappingContext<K> embedded(Embedded embedded) {
            if (this.associations == null) {
                this.associations = new LinkedHashMap<Association, MappingContext>();
            }
            return this.associations.computeIfAbsent((Association)embedded, e -> this.embeddedAssociation(embedded));
        }

        public <K> MappingContext<K> path(Association association) {
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, this.namingStrategy, this.prefix, this.jp, this.joinPath, MappingContext.associated(this.embeddedPath, association), association);
        }

        public <K> MappingContext<K> join(Map<String, JoinPath> joinPaths, Association association) {
            if (this.associations == null) {
                this.associations = new LinkedHashMap<Association, MappingContext>();
            }
            return this.associations.computeIfAbsent(association, a -> this.joinAssociation(joinPaths, association));
        }

        public <K> MappingContext<K> associate(MappingContext<K> ctx, @NotNull Object associationId, @NotNull Object entity) {
            ctx.entity = entity;
            if (this.manyAssociations == null) {
                this.manyAssociations = new LinkedHashMap<Object, MappingContext>();
            }
            this.manyAssociations.put(associationId, ctx);
            return ctx;
        }

        private <K> MappingContext<K> copy() {
            MappingContext<E> ctx = new MappingContext<E>(this.rootPersistentEntity, this.persistentEntity, this.namingStrategy, this.prefix, this.jp, this.joinPath, this.embeddedPath, this.association);
            return ctx;
        }

        private <K> MappingContext<K> joinAssociation(Map<String, JoinPath> joinPaths, Association association) {
            JoinPath jp = this.findJoinPath(joinPaths, association);
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, associatedEntity.getNamingStrategy(), jp == null ? this.prefix : jp.getAlias().orElse(this.prefix), jp, MappingContext.associated(this.joinPath, association), Collections.emptyList(), association);
        }

        private <K> MappingContext<K> embeddedAssociation(Embedded embedded) {
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)embedded.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, associatedEntity.findNamingStrategy().orElse(this.namingStrategy), this.prefix, this.jp, this.joinPath, MappingContext.associated(this.embeddedPath, (Association)embedded), (Association)embedded);
        }

        private JoinPath findJoinPath(Map<String, JoinPath> joinPaths, Association association) {
            String path;
            JoinPath jp = null;
            if (!joinPaths.isEmpty() && (jp = joinPaths.get(path = this.asPath(this.joinPath, this.embeddedPath, (PersistentProperty)association))) == null && (jp = joinPaths.get(path = this.asPath(this.joinPath, (PersistentProperty)association))) == null) {
                RuntimePersistentProperty identity = this.rootPersistentEntity.getIdentity();
                if (identity instanceof Embedded) {
                    path = identity.getName() + "." + path;
                }
                jp = joinPaths.get(path);
            }
            if (jp == null) {
                return null;
            }
            String alias = jp.getAlias().orElse(null);
            if (alias == null) {
                alias = association.getAliasName();
                if (!this.embeddedPath.isEmpty()) {
                    StringBuilder sb = this.prefix == null ? new StringBuilder() : new StringBuilder(this.prefix);
                    for (Association embedded : this.embeddedPath) {
                        sb.append(embedded.getName());
                        sb.append('_');
                    }
                    sb.append(alias);
                    alias = sb.toString();
                } else {
                    alias = this.prefix == null ? alias : this.prefix + alias;
                }
            }
            return new JoinPath(jp.getPath(), jp.getAssociationPath(), jp.getJoinType(), alias);
        }

        private String asPath(List<Association> joinPath, List<Association> embeddedPath, PersistentProperty property) {
            if (joinPath.isEmpty() && embeddedPath.isEmpty()) {
                return property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : joinPath) {
                joiner.add(association.getName());
            }
            for (Association association : embeddedPath) {
                joiner.add(association.getName());
            }
            joiner.add(property.getName());
            return joiner.toString();
        }

        private String asPath(List<Association> associations, PersistentProperty property) {
            if (associations.isEmpty()) {
                return property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : associations) {
                joiner.add(association.getName());
            }
            joiner.add(property.getName());
            return joiner.toString();
        }

        private static List<Association> associated(List<Association> associations, Association association) {
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(association);
            return newAssociations;
        }
    }
}

