/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.DataConversionServiceImpl;
import jakarta.inject.Singleton;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

@Internal
@Factory
final class DataConversionServiceFactory {
    DataConversionServiceFactory() {
    }

    @Singleton
    @Bean(typed={DataConversionService.class})
    DataConversionServiceImpl build() {
        DataConversionServiceImpl dataConversionService = new DataConversionServiceImpl();
        this.initialize(dataConversionService);
        return dataConversionService;
    }

    private void initialize(DataConversionService<?> conversionService) {
        conversionService.addConverter(Enum.class, Number.class, Enum::ordinal);
        conversionService.addConverter(Number.class, Enum.class, (index, targetType, context) -> {
            Enum[] enumConstants = (Enum[])targetType.getEnumConstants();
            int i = index.intValue();
            if (i >= enumConstants.length) {
                throw new IllegalStateException("Cannot find an enum value at index: " + i + " for enum: " + targetType);
            }
            return Optional.of(enumConstants[i]);
        });
        conversionService.addConverter(Number.class, Character.class, number -> Character.valueOf((char)number.intValue()));
        conversionService.addConverter(byte[].class, UUID.class, UUID::nameUUIDFromBytes);
        conversionService.addConverter(java.util.Date.class, LocalDate.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
        conversionService.addConverter(ChronoLocalDate.class, java.util.Date.class, localDate -> new java.util.Date(localDate.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        conversionService.addConverter(String[].class, Character[].class, values -> {
            Character[] chars = new Character[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = Character.valueOf(value.length() == 0 ? (char)'\u0000' : value.charAt(0));
            }
            return chars;
        });
        conversionService.addConverter(String[].class, char[].class, values -> {
            char[] chars = new char[((String[])values).length];
            for (int i = 0; i < ((String[])values).length; ++i) {
                String value = values[i];
                chars[i] = value.length() == 0 ? (char)'\u0000' : value.charAt(0);
            }
            return chars;
        });
        conversionService.addConverter(Character[].class, String[].class, values -> {
            String[] strings = new String[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                strings[i] = values[i].toString();
            }
            return strings;
        });
        conversionService.addConverter(char[].class, String[].class, values -> {
            String[] strings = new String[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                strings[i] = String.valueOf(values[i]);
            }
            return strings;
        });
        conversionService.addConverter(Collection.class, Character[].class, collection -> {
            Character[] chars = new Character[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService);
            }
            return chars;
        });
        conversionService.addConverter(Collection.class, char[].class, collection -> {
            char[] chars = new char[collection.size()];
            int i = 0;
            for (Object value : collection) {
                chars[i++] = this.asCharacter(value, conversionService).charValue();
            }
            return chars;
        });
        conversionService.addConverter(Character[].class, char[].class, values -> {
            char[] chars = new char[((Character[])values).length];
            for (int i = 0; i < ((Character[])values).length; ++i) {
                chars[i] = values[i].charValue();
            }
            return chars;
        });
        conversionService.addConverter(char[].class, Character[].class, values -> {
            Character[] chars = new Character[((char[])values).length];
            for (int i = 0; i < ((char[])values).length; ++i) {
                chars[i] = Character.valueOf(values[i]);
            }
            return chars;
        });
        conversionService.addConverter(Collection.class, Short[].class, collection -> {
            Short[] shorts = new Short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Collection.class, short[].class, collection -> {
            short[] shorts = new short[collection.size()];
            int i = 0;
            for (Object value : collection) {
                shorts[i++] = this.asShort(value, conversionService);
            }
            return shorts;
        });
        conversionService.addConverter(Short[].class, short[].class, values -> {
            short[] shorts = new short[((Short[])values).length];
            for (int i = 0; i < ((Short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter(short[].class, Short[].class, values -> {
            Short[] shorts = new Short[((short[])values).length];
            for (int i = 0; i < ((short[])values).length; ++i) {
                shorts[i] = values[i];
            }
            return shorts;
        });
        conversionService.addConverter(Collection.class, Float[].class, collection -> {
            Float[] floats = new Float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService);
            }
            return floats;
        });
        conversionService.addConverter(Collection.class, float[].class, collection -> {
            float[] floats = new float[collection.size()];
            int i = 0;
            for (Object value : collection) {
                floats[i++] = this.asFloat(value, conversionService).floatValue();
            }
            return floats;
        });
        conversionService.addConverter(Float[].class, float[].class, values -> {
            float[] floats = new float[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                floats[i] = values[i].floatValue();
            }
            return floats;
        });
        conversionService.addConverter(float[].class, Float[].class, values -> {
            Float[] floats = new Float[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                floats[i] = Float.valueOf(values[i]);
            }
            return floats;
        });
        conversionService.addConverter(Float[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Float[])values).length];
            for (int i = 0; i < ((Float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i].floatValue());
            }
            return bigs;
        });
        conversionService.addConverter(float[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((float[])values).length];
            for (int i = 0; i < ((float[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(Collection.class, Integer[].class, collection -> {
            Integer[] ints = new Integer[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Collection.class, int[].class, collection -> {
            int[] ints = new int[collection.size()];
            int i = 0;
            for (Object value : collection) {
                ints[i++] = this.asInteger(value, conversionService);
            }
            return ints;
        });
        conversionService.addConverter(Integer[].class, int[].class, values -> {
            int[] ints = new int[((Integer[])values).length];
            for (int i = 0; i < ((Integer[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter(int[].class, Integer[].class, values -> {
            Integer[] ints = new Integer[((int[])values).length];
            for (int i = 0; i < ((int[])values).length; ++i) {
                ints[i] = values[i];
            }
            return ints;
        });
        conversionService.addConverter(Collection.class, Long[].class, collection -> {
            Long[] longs = new Long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Collection.class, long[].class, collection -> {
            long[] longs = new long[collection.size()];
            int i = 0;
            for (Object value : collection) {
                longs[i++] = this.asLong(value, conversionService);
            }
            return longs;
        });
        conversionService.addConverter(Long[].class, long[].class, values -> {
            long[] longs = new long[((Long[])values).length];
            for (int i = 0; i < ((Long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter(long[].class, Long[].class, values -> {
            Long[] longs = new Long[((long[])values).length];
            for (int i = 0; i < ((long[])values).length; ++i) {
                longs[i] = values[i];
            }
            return longs;
        });
        conversionService.addConverter(Collection.class, Double[].class, collection -> {
            Double[] doubles = new Double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Collection.class, double[].class, collection -> {
            double[] doubles = new double[collection.size()];
            int i = 0;
            for (Object value : collection) {
                doubles[i++] = this.asDouble(value, conversionService);
            }
            return doubles;
        });
        conversionService.addConverter(Double[].class, double[].class, values -> {
            double[] doubles = new double[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter(double[].class, Double[].class, values -> {
            Double[] doubles = new Double[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                doubles[i] = values[i];
            }
            return doubles;
        });
        conversionService.addConverter(Double[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((Double[])values).length];
            for (int i = 0; i < ((Double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(double[].class, BigDecimal[].class, values -> {
            BigDecimal[] bigs = new BigDecimal[((double[])values).length];
            for (int i = 0; i < ((double[])values).length; ++i) {
                bigs[i] = BigDecimal.valueOf(values[i]);
            }
            return bigs;
        });
        conversionService.addConverter(Collection.class, Boolean[].class, collection -> {
            Boolean[] booleans = new Boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Collection.class, boolean[].class, collection -> {
            boolean[] booleans = new boolean[collection.size()];
            int i = 0;
            for (Object value : collection) {
                booleans[i++] = this.asBoolean(value, conversionService);
            }
            return booleans;
        });
        conversionService.addConverter(Boolean[].class, boolean[].class, values -> {
            boolean[] booleans = new boolean[((Boolean[])values).length];
            for (int i = 0; i < ((Boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter(boolean[].class, Boolean[].class, values -> {
            Boolean[] booleans = new Boolean[((boolean[])values).length];
            for (int i = 0; i < ((boolean[])values).length; ++i) {
                booleans[i] = values[i];
            }
            return booleans;
        });
        conversionService.addConverter(Instant.class, java.util.Date.class, java.util.Date::from);
        conversionService.addConverter(Instant.class, Timestamp.class, Timestamp::from);
        conversionService.addConverter(java.util.Date.class, Instant.class, java.util.Date::toInstant);
        conversionService.addConverter(Date.class, Instant.class, date -> Instant.ofEpochMilli(date.getTime()));
        conversionService.addConverter(Timestamp.class, ZonedDateTime.class, timestamp -> timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()));
        conversionService.addConverter(ZonedDateTime.class, Timestamp.class, zonedDateTime -> Timestamp.from(zonedDateTime.toInstant()));
        conversionService.addConverter(LocalTime.class, Timestamp.class, localTime -> Timestamp.valueOf(localTime.atDate(LocalDate.now())));
        conversionService.addConverter(Timestamp.class, LocalTime.class, timestamp -> timestamp.toLocalDateTime().toLocalTime());
        conversionService.addConverter(LocalDateTime.class, java.util.Date.class, localDateTime -> new java.util.Date(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        conversionService.addConverter(LocalDateTime.class, Timestamp.class, Timestamp::valueOf);
        conversionService.addConverter(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime);
        conversionService.addConverter(java.util.Date.class, LocalDateTime.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime());
        conversionService.addConverter(java.util.Date.class, OffsetDateTime.class, date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toOffsetDateTime());
        conversionService.addConverter(OffsetDateTime.class, java.util.Date.class, offsetDateTime2 -> new java.util.Date(offsetDateTime2.toInstant().toEpochMilli()));
        conversionService.addConverter(OffsetDateTime.class, Date.class, offsetDateTime1 -> new Date(offsetDateTime1.toInstant().toEpochMilli()));
        conversionService.addConverter(OffsetDateTime.class, Timestamp.class, offsetDateTime1 -> Timestamp.from(offsetDateTime1.toInstant()));
        conversionService.addConverter(Timestamp.class, OffsetDateTime.class, timestamp -> OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
        conversionService.addConverter(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        conversionService.addConverter(OffsetDateTime.class, LocalDate.class, OffsetDateTime::toLocalDate);
        conversionService.addConverter(OffsetDateTime.class, LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        conversionService.addConverter(OffsetDateTime.class, Long.class, offsetDateTime -> offsetDateTime.toInstant().toEpochMilli());
    }

    private Integer asInteger(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return (Integer)dataConversionService.convertRequired(value, Integer.class);
    }

    private Long asLong(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return (Long)dataConversionService.convertRequired(value, Long.class);
    }

    private Double asDouble(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return (Double)dataConversionService.convertRequired(value, Double.class);
    }

    private Boolean asBoolean(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)dataConversionService.convertRequired(value, Boolean.class);
    }

    private Float asFloat(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return (Float)dataConversionService.convertRequired(value, Float.class);
    }

    private Short asShort(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return (Short)dataConversionService.convertRequired(value, Short.class);
    }

    private Character asCharacter(Object value, DataConversionService<?> dataConversionService) {
        if (value instanceof Character) {
            return (Character)value;
        }
        return (Character)dataConversionService.convertRequired(value, Character.class);
    }
}

