/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    private final Map<RepositoryMethodKey, SqlQueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, SqlQueryBuilder>();
    private final RuntimeCriteriaBuilder criteriaBuilder;

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)operations.getApplicationContext().getBean(RuntimeEntityRegistry.class);
        this.criteriaBuilder = new RuntimeCriteriaBuilder(runtimeEntityRegistry);
    }

    protected final <E, QR> PreparedQuery<E, QR> preparedQueryForCriteria(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Type type) {
        String[] queryParts;
        QueryResult queryResult;
        Object predicate;
        PersistentEntityRoot root;
        QuerySpecification<Object> specification;
        Class<Object> rootEntity = this.getRequiredRootEntity(context);
        Pageable pageable = Pageable.UNPAGED;
        for (Object param : context.getParameterValues()) {
            if (!(param instanceof Pageable)) continue;
            pageable = (Pageable)param;
            break;
        }
        SqlQueryBuilder sqlQueryBuilder = this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> new SqlQueryBuilder(context.getAnnotationMetadata()));
        if (type == Type.COUNT || type == Type.FIND_ALL || type == Type.FIND_ONE || type == Type.FIND_PAGE) {
            specification = this.getQuerySpecification(context);
            PersistentEntityCriteriaQuery<Object> criteriaQuery = this.criteriaBuilder.createQuery();
            root = criteriaQuery.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaQuery, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            if (type == Type.FIND_ALL) {
                for (Predicate param : context.getParameterValues()) {
                    Sort sort;
                    if (!(param instanceof Sort) || !(sort = (Sort)param).isSorted()) continue;
                    criteriaQuery.orderBy(this.getOrders(sort, (Root<?>)root, (CriteriaBuilder)this.criteriaBuilder));
                    break;
                }
            } else if (type == Type.COUNT) {
                criteriaQuery.select((Selection)this.criteriaBuilder.count((Expression)root));
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery((QueryBuilder)sqlQueryBuilder);
        } else if (type == Type.DELETE_ALL) {
            specification = this.getDeleteSpecification(context);
            PersistentEntityCriteriaDelete criteriaDelete = this.criteriaBuilder.createCriteriaDelete(rootEntity);
            root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaDelete, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaDelete).buildQuery((QueryBuilder)sqlQueryBuilder);
        } else if (type == Type.UPDATE_ALL) {
            specification = this.getUpdateSpecification(context);
            PersistentEntityCriteriaUpdate criteriaUpdate = this.criteriaBuilder.createCriteriaUpdate(rootEntity);
            root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaUpdate, (CriteriaBuilder)this.criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaUpdate).buildQuery((QueryBuilder)sqlQueryBuilder);
        } else {
            throw new IllegalStateException("Unknown criteria type: " + (Object)((Object)type));
        }
        String query = queryResult.getQuery();
        List parameterBindings = queryResult.getParameterBindings();
        ArrayList<QueryParameterBinding> queryParameters = new ArrayList<QueryParameterBinding>(parameterBindings.size());
        for (io.micronaut.data.model.query.builder.QueryParameterBinding p : parameterBindings) {
            queryParameters.add(new QueryResultParameterBinding(p, queryParameters));
        }
        String[] stringArray = queryParts = queryParameters.stream().anyMatch(QueryParameterBinding::isExpandable) ? queryResult.getQueryParts().toArray(new String[0]) : null;
        Object storedQuery = type == Type.COUNT ? this.createCountStoredQuery(context, rootEntity, query, queryParts, queryParameters) : (type == Type.FIND_ALL ? this.createFindAllStoredQuery(context, rootEntity, query, queryParts, queryParameters, !pageable.isUnpaged()) : this.createFindOneStoredQuery(context, rootEntity, query, queryParts, queryParameters));
        return new AbstractQueryInterceptor.DefaultPreparedQuery<Object, Long>(this, context, (StoredQuery<Object, Long>)storedQuery, query, pageable, false);
    }

    private <E, QR> StoredQuery<E, QR> createFindOneStoredQuery(final MethodInvocationContext<T, R> context, final Class<Object> rootEntity, final String query, final String[] queryParts, final List<QueryParameterBinding> queryParameters) {
        return new StoredQuery<E, QR>(){

            public Class<E> getRootEntity() {
                return rootEntity;
            }

            public boolean hasPageable() {
                return false;
            }

            public String getQuery() {
                return query;
            }

            public String[] getExpandableQueryParts() {
                return queryParts;
            }

            public List<QueryParameterBinding> getQueryBindings() {
                return queryParameters;
            }

            public Class<QR> getResultType() {
                return rootEntity;
            }

            public Argument<QR> getResultArgument() {
                return Argument.of(this.getResultType());
            }

            public DataType getResultDataType() {
                return DataType.ENTITY;
            }

            public boolean useNumericPlaceholders() {
                return context.getExecutableMethod().classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            }

            public boolean isCount() {
                return false;
            }

            public boolean isSingleResult() {
                return true;
            }

            public boolean hasResultConsumer() {
                return false;
            }

            public String getName() {
                return context.getMethodName();
            }
        };
    }

    private <E, QR> StoredQuery<E, QR> createFindAllStoredQuery(final MethodInvocationContext<T, R> context, final Class<Object> rootEntity, final String query, final String[] queryParts, final List<QueryParameterBinding> queryParameters, final boolean hasPageable) {
        return new StoredQuery<E, QR>(){

            public Class<E> getRootEntity() {
                return rootEntity;
            }

            public boolean hasPageable() {
                return hasPageable;
            }

            public String getQuery() {
                return query;
            }

            public String[] getExpandableQueryParts() {
                return queryParts;
            }

            public List<QueryParameterBinding> getQueryBindings() {
                return queryParameters;
            }

            public Class<QR> getResultType() {
                return rootEntity;
            }

            public Argument<QR> getResultArgument() {
                return Argument.of(this.getResultType());
            }

            public DataType getResultDataType() {
                return DataType.ENTITY;
            }

            public boolean useNumericPlaceholders() {
                return context.getExecutableMethod().classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            }

            public boolean isCount() {
                return false;
            }

            public boolean isSingleResult() {
                return false;
            }

            public boolean hasResultConsumer() {
                return false;
            }

            public String getName() {
                return context.getMethodName();
            }
        };
    }

    private StoredQuery<Object, Long> createCountStoredQuery(final MethodInvocationContext<T, R> context, final Class<Object> rootEntity, final String query, final String[] queryParts, final List<QueryParameterBinding> queryParameters) {
        return new StoredQuery<Object, Long>(){

            public Class<Object> getRootEntity() {
                return rootEntity;
            }

            public boolean hasPageable() {
                return false;
            }

            public String getQuery() {
                return query;
            }

            public String[] getExpandableQueryParts() {
                return queryParts;
            }

            public List<QueryParameterBinding> getQueryBindings() {
                return queryParameters;
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public Argument<Long> getResultArgument() {
                return Argument.LONG;
            }

            public DataType getResultDataType() {
                return DataType.LONG;
            }

            public boolean useNumericPlaceholders() {
                return context.getExecutableMethod().classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
            }

            public boolean isCount() {
                return true;
            }

            public boolean isSingleResult() {
                return true;
            }

            public boolean hasResultConsumer() {
                return false;
            }

            public String getName() {
                return context.getMethodName();
            }
        };
    }

    @Nullable
    protected QuerySpecification<Object> getQuerySpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof QuerySpecification) {
            return (QuerySpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return QuerySpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(QuerySpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + QuerySpecification.class + " or " + PredicateSpecification.class);
    }

    @Nullable
    protected DeleteSpecification<Object> getDeleteSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof DeleteSpecification) {
            return (DeleteSpecification)parameterValue;
        }
        if (parameterValue instanceof PredicateSpecification) {
            return DeleteSpecification.where((PredicateSpecification)((PredicateSpecification)parameterValue));
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(DeleteSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + DeleteSpecification.class + " or " + PredicateSpecification.class);
    }

    @Nullable
    protected UpdateSpecification<Object> getUpdateSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof UpdateSpecification) {
            return (UpdateSpecification)parameterValue;
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isAssignableFrom(UpdateSpecification.class) || parameterArgument.isAssignableFrom(PredicateSpecification.class)) {
            return null;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + UpdateSpecification.class);
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root.get(order.getProperty());
            orders.add(order.isAscending() ? cb.asc((Expression)propertyPath) : cb.desc((Expression)propertyPath));
        }
        return orders;
    }

    private static class QueryResultParameterBinding
    implements QueryParameterBinding {
        private final io.micronaut.data.model.query.builder.QueryParameterBinding p;
        private final List<QueryParameterBinding> all;
        private boolean previousInitialized;
        private QueryParameterBinding previousPopulatedValueParameter;

        public QueryResultParameterBinding(io.micronaut.data.model.query.builder.QueryParameterBinding p, List<QueryParameterBinding> all) {
            this.p = p;
            this.all = all;
        }

        public String getName() {
            return this.p.getKey();
        }

        public DataType getDataType() {
            return this.p.getDataType();
        }

        public Class<?> getParameterConverterClass() {
            return (Class)ClassUtils.forName((String)this.p.getConverterClassName(), null).get();
        }

        public int getParameterIndex() {
            return this.p.getParameterIndex();
        }

        public String[] getParameterBindingPath() {
            return this.p.getParameterBindingPath();
        }

        public String[] getPropertyPath() {
            return this.p.getPropertyPath();
        }

        public boolean isAutoPopulated() {
            return this.p.isAutoPopulated();
        }

        public boolean isRequiresPreviousPopulatedValue() {
            return this.p.isRequiresPreviousPopulatedValue();
        }

        public QueryParameterBinding getPreviousPopulatedValueParameter() {
            if (!this.previousInitialized) {
                for (QueryParameterBinding it : this.all) {
                    if (it == this || it.getParameterIndex() == -1 || !Arrays.equals(this.getPropertyPath(), it.getPropertyPath())) continue;
                    this.previousPopulatedValueParameter = it;
                    break;
                }
                this.previousInitialized = true;
            }
            return this.previousPopulatedValueParameter;
        }

        public boolean isExpandable() {
            return this.p.isExpandable();
        }
    }

    protected static enum Type {
        COUNT,
        FIND_ONE,
        FIND_PAGE,
        FIND_ALL,
        DELETE_ALL,
        UPDATE_ALL;

    }
}

