/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.data.runtime.convert.DataConversionService;
import java.util.Optional;
import java.util.function.Function;

@Internal
final class DataConversionServiceImpl
implements DataConversionService<DataConversionServiceImpl> {
    private final DefaultConversionService internalConversionService = new DefaultConversionService();
    private final ConversionService sharedConversionService = ConversionService.SHARED;

    DataConversionServiceImpl() {
    }

    public <S, T> DataConversionServiceImpl addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> typeConverter) {
        this.internalConversionService.addConverter(sourceType, targetType, typeConverter);
        return this;
    }

    public <S, T> DataConversionServiceImpl addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        this.internalConversionService.addConverter(sourceType, targetType, typeConverter);
        return this;
    }

    public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
        Optional result = this.internalConversionService.convert(object, targetType, context);
        if (result.isPresent()) {
            return result;
        }
        return this.sharedConversionService.convert(object, targetType, context);
    }

    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        return this.internalConversionService.canConvert(sourceType, targetType) || this.sharedConversionService.canConvert(sourceType, targetType);
    }
}

