/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.SyncCascadeOperations;
import io.micronaut.data.runtime.operations.internal.SyncEntitiesOperations;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractSyncEntitiesOperations<Ctx extends OperationContext, T, Exc extends Exception>
extends SyncEntitiesOperations<T, Exc> {
    protected final Ctx ctx;
    protected final SyncCascadeOperations<Ctx> cascadeOperations;
    protected final ConversionService conversionService;
    protected final List<Data> entities;
    protected final boolean insert;
    protected final boolean hasGeneratedId;

    protected AbstractSyncEntitiesOperations(Ctx ctx, SyncCascadeOperations<Ctx> cascadeOperations, ConversionService conversionService, EntityEventListener<Object> entityEventListener, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
        super(entityEventListener, persistentEntity, conversionService);
        Stream stream;
        this.cascadeOperations = cascadeOperations;
        this.conversionService = conversionService;
        this.ctx = ctx;
        this.insert = insert;
        this.hasGeneratedId = insert && persistentEntity.getIdentity() != null && persistentEntity.getIdentity().isGenerated();
        Objects.requireNonNull(entities, "Entities cannot be null");
        if (entities instanceof Collection) {
            Collection collection = (Collection)entities;
            stream = collection.stream();
        } else {
            stream = CollectionUtils.iterableToList(entities).stream();
        }
        this.entities = stream.map(entity -> {
            Data d = new Data();
            d.entity = entity;
            return d;
        }).toList();
    }

    @Override
    protected void cascadePre(Relation.Cascade cascadeType) {
        for (Data d : this.entities) {
            if (d.vetoed) continue;
            d.entity = this.cascadeOperations.cascadeEntity(this.ctx, d.entity, this.persistentEntity, false, cascadeType);
        }
    }

    @Override
    protected void cascadePost(Relation.Cascade cascadeType) {
        for (Data d : this.entities) {
            if (d.vetoed) continue;
            d.entity = this.cascadeOperations.cascadeEntity(this.ctx, d.entity, this.persistentEntity, true, cascadeType);
        }
    }

    @Override
    protected void collectAutoPopulatedPreviousValues() {
    }

    @Override
    public void veto(Predicate<T> predicate) {
        for (Data d : this.entities) {
            if (d.vetoed) continue;
            d.vetoed = predicate.test(d.entity);
        }
    }

    @Override
    protected boolean triggerPre(Function<EntityEventContext<Object>, Boolean> fn) {
        boolean allVetoed = true;
        for (Data d : this.entities) {
            if (d.vetoed) continue;
            DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
            if (!fn.apply(event).booleanValue()) {
                d.vetoed = true;
                continue;
            }
            d.entity = event.getEntity();
            allVetoed = false;
        }
        return allVetoed;
    }

    @Override
    protected void triggerPost(Consumer<EntityEventContext<Object>> fn) {
        for (Data d : this.entities) {
            if (d.vetoed) continue;
            DefaultEntityEventContext event = new DefaultEntityEventContext(this.persistentEntity, d.entity);
            fn.accept(event);
            d.entity = event.getEntity();
        }
    }

    @Override
    public List<T> getEntities() {
        return this.entities.stream().map(d -> d.entity).collect(Collectors.toList());
    }

    protected class Data {
        public T entity;
        public Map<QueryParameterBinding, Object> previousValues;
        public boolean vetoed = false;

        protected Data() {
        }
    }
}

