/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.AbstractPreparedDataOperation;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.DeleteReturningBatchOperation;
import io.micronaut.data.model.runtime.DeleteReturningOperation;
import io.micronaut.data.model.runtime.EntityInstanceOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredDataOperation;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.query.DefaultPagedQueryResolver;
import io.micronaut.data.runtime.query.DefaultPreparedQueryResolver;
import io.micronaut.data.runtime.query.DefaultStoredQueryResolver;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PagedQueryResolver;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryResolver;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractQueryInterceptor<T, R>
implements DataInterceptor<T, R> {
    protected final ConversionService conversionService;
    protected final RepositoryOperations operations;
    protected final PreparedQueryResolver preparedQueryResolver;
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> countQueries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);
    private final ConcurrentMap<RepositoryMethodKey, StoredQuery> queries = new ConcurrentHashMap<RepositoryMethodKey, StoredQuery>(50);
    private final StoredQueryResolver storedQueryResolver;
    private final MethodContextAwareStoredQueryDecorator storedQueryDecorator;
    private final PagedQueryResolver pagedQueryResolver;
    private final PreparedQueryDecorator preparedQueryDecorator;

    protected AbstractQueryInterceptor(final @NonNull RepositoryOperations operations) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        this.conversionService = operations.getConversionService();
        this.operations = operations;
        StoredQueryResolver storedQueryResolver = this.storedQueryResolver = operations instanceof StoredQueryResolver ? (StoredQueryResolver)operations : new DefaultStoredQueryResolver(){

            @Override
            protected HintsCapableRepository getHintsCapableRepository() {
                return operations;
            }
        };
        if (operations instanceof MethodContextAwareStoredQueryDecorator) {
            this.storedQueryDecorator = (MethodContextAwareStoredQueryDecorator)operations;
        } else if (operations instanceof StoredQueryDecorator) {
            final StoredQueryDecorator decorator = (StoredQueryDecorator)operations;
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return decorator.decorate(storedQuery);
                }
            };
        } else {
            this.storedQueryDecorator = new MethodContextAwareStoredQueryDecorator(){

                public <E, K> StoredQuery<E, K> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, K> storedQuery) {
                    return storedQuery;
                }
            };
        }
        this.preparedQueryResolver = operations instanceof PreparedQueryResolver ? (PreparedQueryResolver)operations : new DefaultPreparedQueryResolver(){

            @Override
            protected ConversionService getConversionService() {
                return operations.getConversionService();
            }
        };
        this.preparedQueryDecorator = operations instanceof PreparedQueryDecorator ? (PreparedQueryDecorator)operations : new PreparedQueryDecorator(){

            public <E, K> PreparedQuery<E, K> decorate(PreparedQuery<E, K> preparedQuery) {
                return preparedQuery;
            }
        };
        this.pagedQueryResolver = operations instanceof PagedQueryResolver ? (PagedQueryResolver)operations : new DefaultPagedQueryResolver();
    }

    @NonNull
    protected Map<String, Object> getParameterValueMap(MethodInvocationContext<?, ?> context) {
        Argument[] arguments = context.getArguments();
        Object[] parameterValues = context.getParameterValues();
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(arguments.length);
        for (int i = 0; i < parameterValues.length; ++i) {
            Object parameterValue = parameterValues[i];
            Argument arg = arguments[i];
            valueMap.put(arg.getAnnotationMetadata().stringValue(Parameter.class).orElseGet(() -> ((Argument)arg).getName()), parameterValue);
        }
        return valueMap;
    }

    protected Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return context.getReturnType().asArgument();
    }

    @Nullable
    protected final Object convertOne(MethodInvocationContext<?, ?> context, @Nullable Object o) {
        Argument argumentType = this.getReturnType(context);
        Class type = argumentType.getType();
        if (o == null) {
            if (type == Optional.class) {
                return Optional.empty();
            }
            if (argumentType.isDeclaredNonNull() || !argumentType.isNullable() && !context.getReturnType().asArgument().isNullable()) {
                throw new EmptyResultException();
            }
            return null;
        }
        boolean isOptional = false;
        if (type == Optional.class) {
            argumentType = argumentType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            isOptional = true;
        }
        o = this.convertOne(o, argumentType);
        if (isOptional) {
            return Optional.of(o);
        }
        return o;
    }

    protected final Object convertOne(Object o, Argument<?> argumentType) {
        if (argumentType.isInstance(o)) {
            return o;
        }
        return this.operations.getConversionService().convertRequired(o, argumentType);
    }

    @NonNull
    protected final PreparedQuery<?, ?> prepareQuery(RepositoryMethodKey key, MethodInvocationContext<T, R> context) {
        return this.prepareQuery(key, context, null);
    }

    @NonNull
    protected final <RT> PreparedQuery<?, RT> prepareQuery(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Class<RT> resultType) {
        return this.prepareQuery(methodKey, context, resultType, false);
    }

    @NonNull
    protected final <RT> PreparedQuery<?, RT> prepareQuery(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, Class<RT> resultType, boolean isCount) {
        this.validateNullArguments(context);
        StoredQuery storedQuery = this.findStoreQuery(methodKey, context, resultType, isCount);
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        PreparedQuery preparedQuery = this.preparedQueryResolver.resolveQuery(context, storedQuery, pageable);
        return this.preparedQueryDecorator.decorate(preparedQuery);
    }

    private <E, RT> StoredQuery<E, RT> findStoreQuery(MethodInvocationContext<?, ?> context, boolean isCount) {
        RepositoryMethodKey key = new RepositoryMethodKey(context.getTarget(), context.getExecutableMethod());
        return this.findStoreQuery(key, context, null, isCount);
    }

    private <E, RT> StoredQuery<E, RT> findStoreQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Class<RT> resultType, boolean isCount) {
        StoredQuery storedQuery = (StoredQuery)this.queries.get(methodKey);
        if (storedQuery == null) {
            Class rootEntity = (Class)context.classValue(DataMethod.NAME, "rootEntity").orElseThrow(() -> new IllegalStateException("No root entity present in method"));
            if (resultType == null) {
                resultType = context.classValue(DataMethod.NAME, "resultType").orElse(rootEntity);
            }
            storedQuery = this.storedQueryResolver.resolveQuery(context, rootEntity, resultType, isCount);
            storedQuery = this.storedQueryDecorator.decorate(context, storedQuery);
            this.queries.put(methodKey, storedQuery);
        }
        return storedQuery;
    }

    @NonNull
    protected final PreparedQuery<?, Number> prepareCountQuery(RepositoryMethodKey methodKey, @NonNull MethodInvocationContext<T, R> context) {
        StoredQuery storedQuery = (StoredQuery)this.countQueries.get(methodKey);
        if (storedQuery == null) {
            Class rootEntity = this.getRequiredRootEntity(context);
            storedQuery = this.storedQueryResolver.resolveCountQuery(context, rootEntity, Long.class);
            storedQuery = this.storedQueryDecorator.decorate(context, storedQuery);
            this.countQueries.put(methodKey, storedQuery);
        }
        Pageable pageable = storedQuery.hasPageable() ? this.getPageable(context) : Pageable.UNPAGED;
        PreparedQuery preparedQuery = this.preparedQueryResolver.resolveCountQuery(context, storedQuery, pageable);
        return this.preparedQueryDecorator.decorate(preparedQuery);
    }

    @NonNull
    protected <E> Class<E> getRequiredRootEntity(MethodInvocationContext context) {
        Class aClass = context.classValue(DataMethod.NAME, "rootEntity").orElse(null);
        if (aClass != null) {
            return aClass;
        }
        AnnotationValue ann = context.getDeclaredAnnotation(DataMethod.NAME);
        if (ann != null && (aClass = (Class)ann.classValue("rootEntity").orElse(null)) != null) {
            return aClass;
        }
        throw new IllegalStateException("No root entity present in method");
    }

    protected <RT> RT getEntityParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getRequiredParameterInRole(context, "entity", type);
    }

    protected <RT> Iterable<RT> getEntitiesParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getRequiredParameterInRole(context, "entities", Iterable.class);
    }

    protected <RT> Optional<RT> findEntityParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        return this.getParameterInRole(context, "entity", type);
    }

    protected <RT> Optional<Iterable<RT>> findEntitiesParameter(MethodInvocationContext<?, ?> context, @NonNull Class<RT> type) {
        Optional<Iterable<RT>> parameterInRole = this.getParameterInRole(context, "entities", Iterable.class);
        return parameterInRole;
    }

    private <RT> RT getRequiredParameterInRole(MethodInvocationContext<?, ?> context, @NonNull String role, @NonNull Class<RT> type) {
        return this.getParameterInRole(context, role, type).orElseThrow(() -> new IllegalStateException("Cannot find parameter with role: " + role));
    }

    private <RT> Optional<RT> getParameterInRole(MethodInvocationContext<?, ?> context, @NonNull String role, @NonNull Class<RT> type) {
        return context.stringValue(DataMethod.NAME, role).flatMap(name -> {
            Object o;
            Object parameterValue = null;
            Map params = context.getParameters();
            MutableArgumentValue arg = (MutableArgumentValue)params.get(name);
            if (arg != null && (o = arg.getValue()) != null) {
                parameterValue = type.isInstance(o) ? o : this.operations.getConversionService().convert(o, type).orElse(null);
            }
            return Optional.ofNullable(parameterValue);
        });
    }

    @NonNull
    protected Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Pageable pageable = this.getParameterInRole(context, "pageable", Pageable.class).orElse(null);
        if (pageable == null) {
            Sort sort = this.getParameterInRole(context, "sort", Sort.class).orElse(null);
            int max = context.intValue(DataMethod.NAME, "pageSize").orElse(-1);
            if (sort != null) {
                int pageIndex = context.intValue(DataMethod.NAME, "pageIndex").orElse(0);
                pageable = max > 0 ? Pageable.from((int)pageIndex, (int)max, (Sort)sort) : Pageable.from((Sort)sort);
            } else if (max > -1) {
                return Pageable.from((int)0, (int)max);
            }
        }
        return pageable != null ? pageable : Pageable.UNPAGED;
    }

    protected boolean isNullable(@NonNull AnnotationMetadata metadata) {
        return metadata.getDeclaredAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName((String)n).equalsIgnoreCase("nullable"));
    }

    @NonNull
    protected Object getRequiredEntity(MethodInvocationContext<T, ?> context) {
        String entityParam = (String)context.stringValue(DataMethod.NAME, "entity").orElseThrow(() -> new IllegalStateException("No entity parameter specified"));
        Object o = context.getParameterValueMap().get(entityParam);
        if (o == null) {
            throw new IllegalArgumentException("Entity argument cannot be null");
        }
        return o;
    }

    @NonNull
    protected Object instantiateEntity(@NonNull Class<?> rootEntity, @NonNull Map<String, Object> parameterValues) {
        Object instance;
        RuntimePersistentEntity entity = this.operations.getEntity(rootEntity);
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(rootEntity);
        Object[] constructorArguments = introspection.getConstructorArguments();
        if (ArrayUtils.isNotEmpty((Object[])constructorArguments)) {
            Object[] arguments = new Object[constructorArguments.length];
            boolean strictNullable = true;
            for (int i = 0; i < constructorArguments.length; ++i) {
                Object argument = constructorArguments[i];
                PersistentProperty[] argumentName = argument.getName();
                Object v = parameterValues.get(argumentName);
                AnnotationMetadata argMetadata = argument.getAnnotationMetadata();
                if (v == null && !PersistentProperty.isNullableMetadata((AnnotationMetadata)argMetadata)) {
                    PersistentProperty prop = entity.getPropertyByName((String)argumentName);
                    if (prop == null || prop.isRequired()) {
                        throw new IllegalArgumentException("Argument [" + (String)argumentName + "] cannot be null");
                    }
                    strictNullable = false;
                }
                arguments[i] = v;
            }
            instance = introspection.instantiate(strictNullable, arguments);
        } else {
            instance = introspection.instantiate();
        }
        BeanWrapper wrapper = BeanWrapper.getWrapper((Object)instance);
        Collection persistentProperties = entity.getPersistentProperties();
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            AbstractQueryInterceptor.setProperty((BeanWrapper<Object>)wrapper, identity, parameterValues);
        } else {
            PersistentProperty[] compositeIdentities = entity.getCompositeIdentity();
            if (compositeIdentities != null && compositeIdentities.length > 0) {
                for (PersistentProperty compositeIdentity : compositeIdentities) {
                    AbstractQueryInterceptor.setProperty((BeanWrapper<Object>)wrapper, compositeIdentity, parameterValues);
                }
            }
        }
        for (PersistentProperty prop : persistentProperties) {
            AbstractQueryInterceptor.setProperty((BeanWrapper<Object>)wrapper, prop, parameterValues);
        }
        return instance;
    }

    @NonNull
    protected <E> PagedQuery<E> getPagedQuery(@NonNull MethodInvocationContext context) {
        return this.pagedQueryResolver.resolveQuery(context, this.getRequiredRootEntity(context), this.getPageable(context));
    }

    @NonNull
    protected <E> InsertBatchOperation<E> getInsertBatchOperation(@NonNull MethodInvocationContext context, @NonNull Iterable<E> iterable) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return this.getInsertBatchOperation(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> InsertBatchOperation<E> getInsertBatchOperation(@NonNull MethodInvocationContext context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultInsertBatchOperation<E>(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext context) {
        Object o = this.getRequiredEntity(context);
        return new DefaultInsertOperation<Object>(context, o);
    }

    @NonNull
    protected <E> UpdateOperation<E> getUpdateOperation(@NonNull MethodInvocationContext<T, ?> context) {
        return this.getUpdateOperation(context, this.getRequiredEntity(context));
    }

    @NonNull
    protected <E> UpdateOperation<E> getUpdateOperation(@NonNull MethodInvocationContext<T, ?> context, E entity) {
        return new DefaultUpdateOperation<E>(context, entity);
    }

    @NonNull
    protected <E> UpdateBatchOperation<E> getUpdateAllBatchOperation(@NonNull MethodInvocationContext<T, ?> context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultUpdateBatchOperation<E>(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> DeleteOperation<E> getDeleteOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull E entity) {
        return new DefaultDeleteOperation<E>(context, entity);
    }

    @NonNull
    protected <E, K> DeleteReturningOperation<E, K> getDeleteReturningOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull E entity) {
        return new DefaultDeleteReturningOperation(context, entity);
    }

    @NonNull
    protected <E> DeleteBatchOperation<E> getDeleteAllBatchOperation(@NonNull MethodInvocationContext<T, ?> context) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return new DefaultDeleteAllBatchOperation<E>(context, rootEntity);
    }

    @NonNull
    protected <E> DeleteBatchOperation<E> getDeleteBatchOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull Iterable<E> iterable) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return this.getDeleteBatchOperation(context, rootEntity, iterable);
    }

    @NonNull
    protected <E, K> DeleteReturningBatchOperation<E, K> getDeleteReturningBatchOperation(@NonNull MethodInvocationContext<T, ?> context, @NonNull Iterable<E> iterable) {
        Class<E> rootEntity = this.getRequiredRootEntity(context);
        return new DefaultDeleteReturningBatchOperation(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> DeleteBatchOperation<E> getDeleteBatchOperation(@NonNull MethodInvocationContext<T, ?> context, Class<E> rootEntity, @NonNull Iterable<E> iterable) {
        return new DefaultDeleteBatchOperation<E>(context, rootEntity, iterable);
    }

    @NonNull
    protected <E> InsertOperation<E> getInsertOperation(@NonNull MethodInvocationContext<T, ?> context, E entity) {
        return new DefaultInsertOperation<E>(context, entity);
    }

    protected final void validateNullArguments(MethodInvocationContext<T, R> context) {
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < parameterValues.length; ++i) {
            Object o = parameterValues[i];
            if (o != null || context.getArguments()[i].isNullable()) continue;
            throw new IllegalArgumentException("Argument [" + context.getArguments()[i].getName() + "] value is null and the method parameter is not declared as nullable");
        }
    }

    protected int count(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        return i;
    }

    protected boolean isNumber(@Nullable Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return ClassUtils.getPrimitiveType((String)type.getName()).map(aClass -> Number.class.isAssignableFrom(ReflectionUtils.getWrapperType((Class)aClass))).orElse(false);
        }
        return Number.class.isAssignableFrom(type);
    }

    private static void setProperty(BeanWrapper<Object> wrapper, PersistentProperty prop, Map<String, Object> parameterValues) {
        if (!prop.isReadOnly() && !prop.isGenerated()) {
            Optional p;
            String propName = prop.getName();
            if (parameterValues.containsKey(propName)) {
                Object v = parameterValues.get(propName);
                if (v == null && !prop.isOptional()) {
                    throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
                }
                wrapper.setProperty(propName, v);
            } else if (prop.isRequired() && !(p = wrapper.getProperty(propName, Object.class)).isPresent()) {
                throw new IllegalArgumentException("Argument [" + propName + "] cannot be null");
            }
        }
    }

    private final class DefaultInsertBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements InsertBatchOperation<E> {
        DefaultInsertBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<InsertOperation<E>> split() {
            ArrayList inserts = new ArrayList(10);
            for (Object e : this.iterable) {
                inserts.add(new DefaultInsertOperation(this.method, e));
            }
            return inserts;
        }
    }

    private final class DefaultInsertOperation<E>
    extends AbstractEntityOperation<E>
    implements InsertOperation<E> {
        private final E entity;

        DefaultInsertOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        public E getEntity() {
            return this.entity;
        }
    }

    private final class DefaultUpdateOperation<E>
    extends AbstractEntityOperation<E>
    implements UpdateOperation<E> {
        private final E entity;

        DefaultUpdateOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        public E getEntity() {
            return this.entity;
        }
    }

    private final class DefaultUpdateBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements UpdateBatchOperation<E> {
        DefaultUpdateBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<UpdateOperation<E>> split() {
            ArrayList updates = new ArrayList(10);
            for (Object e : this.iterable) {
                updates.add(new DefaultUpdateOperation(this.method, e));
            }
            return updates;
        }
    }

    private final class DefaultDeleteOperation<E>
    extends AbstractEntityInstanceOperation<E>
    implements DeleteOperation<E> {
        DefaultDeleteOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity);
        }
    }

    private final class DefaultDeleteReturningOperation<E, K>
    extends AbstractEntityInstanceOperation<E>
    implements DeleteReturningOperation<E, K> {
        DefaultDeleteReturningOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity);
        }

        @Override
        public StoredQuery<E, K> getStoredQuery() {
            return super.getStoredQuery();
        }
    }

    private final class DefaultDeleteAllBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements DeleteBatchOperation<E> {
        DefaultDeleteAllBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity) {
            super(method, rootEntity, Collections.emptyList());
        }

        public boolean all() {
            return true;
        }

        public List<DeleteOperation<E>> split() {
            throw new IllegalStateException("Split is not supported for delete all operation!");
        }
    }

    private final class DefaultDeleteReturningBatchOperation<E, K>
    extends DefaultDeleteBatchOperation<E>
    implements DeleteReturningBatchOperation<E, K> {
        DefaultDeleteReturningBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        @Override
        public StoredQuery<E, K> getStoredQuery() {
            return super.getStoredQuery();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private class DefaultDeleteBatchOperation<E>
    extends DefaultBatchOperation<E>
    implements DeleteBatchOperation<E> {
        DefaultDeleteBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity, iterable);
        }

        public List<DeleteOperation<E>> split() {
            ArrayList deletes = new ArrayList(10);
            for (Object e : this.iterable) {
                deletes.add(new DefaultDeleteOperation(this.method, e));
            }
            return deletes;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private class DefaultBatchOperation<E>
    extends AbstractEntityOperation<E>
    implements BatchOperation<E> {
        protected final Iterable<E> iterable;

        public DefaultBatchOperation(@NonNull MethodInvocationContext<?, ?> method, Class<E> rootEntity, Iterable<E> iterable) {
            super(method, rootEntity);
            this.iterable = iterable;
        }

        public Iterator<E> iterator() {
            return this.iterable.iterator();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private abstract class AbstractEntityOperation<E>
    extends AbstractPreparedDataOperation<E>
    implements EntityOperation<E> {
        protected final MethodInvocationContext<?, ?> method;
        protected final Class<E> rootEntity;
        protected StoredQuery<E, ?> storedQuery;

        AbstractEntityOperation(MethodInvocationContext<?, ?> method, Class<E> rootEntity) {
            super(method, (StoredDataOperation)new DefaultStoredDataOperation(method.getExecutableMethod()));
            this.method = method;
            this.rootEntity = rootEntity;
        }

        public StoredQuery<E, ?> getStoredQuery() {
            if (this.storedQuery == null) {
                String queryString = this.method.stringValue(Query.class).orElse(null);
                if (queryString == null) {
                    return null;
                }
                this.storedQuery = AbstractQueryInterceptor.this.findStoreQuery(this.method, false);
            }
            return this.storedQuery;
        }

        public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
            return AbstractQueryInterceptor.this.getParameterInRole(this.method, role, type);
        }

        @NonNull
        public Class<E> getRootEntity() {
            return this.rootEntity;
        }

        @NonNull
        public Class<?> getRepositoryType() {
            return this.method.getTarget().getClass();
        }

        @NonNull
        public String getName() {
            return this.method.getDeclaringType().getSimpleName() + "." + this.method.getMethodName();
        }

        public InvocationContext<?, ?> getInvocationContext() {
            return this.method;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private abstract class AbstractEntityInstanceOperation<E>
    extends AbstractEntityOperation<E>
    implements EntityInstanceOperation<E> {
        private final E entity;

        AbstractEntityInstanceOperation(MethodInvocationContext<?, ?> method, E entity) {
            super(method, entity.getClass());
            this.entity = entity;
        }

        @NonNull
        public E getEntity() {
            return this.entity;
        }
    }
}

