/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.reactive.AbstractReactiveSpecificationInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class FindPageReactiveSpecificationInterceptor
extends AbstractReactiveSpecificationInterceptor<Object, Object> {
    protected FindPageReactiveSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Mono result;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            Flux results = Flux.from(this.findAllReactive(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE));
            result = results.collectList().map(resultList -> Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size())));
        } else {
            result = Flux.from(this.findAllReactive(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE)).collectList().flatMap(list -> pageable.requestTotal() ? Mono.from(this.countReactive(methodKey, context)).map(count -> this.getPage((List<Object>)list, pageable, (Long)count, context)) : Mono.just((Object)this.getPage((List<Object>)list, pageable, null, context)));
        }
        return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)result, (Class)context.getReturnType().getType());
    }

    private Page getPage(List<Object> list, Pageable pageable, Long count, MethodInvocationContext<Object, Object> context) {
        Page page;
        if (pageable.getMode() == Pageable.Mode.OFFSET) {
            page = Page.of(list, (Pageable)pageable, (Long)count);
        } else {
            PreparedQuery preparedQuery = context.getAttribute((CharSequence)"PREPARED_QUERY").orElse(null);
            if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                List<Pageable.Cursor> cursors = sqlPreparedQuery.createCursors(list, pageable);
                page = CursoredPage.of(list, (Pageable)pageable, cursors, (Long)count);
            } else {
                throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
            }
        }
        return page;
    }
}

