/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate5;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.CannotCreateTransactionException;
import io.micronaut.transaction.exceptions.IllegalTransactionStateException;
import io.micronaut.transaction.exceptions.InvalidIsolationLevelException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.hibernate5.SessionFactoryUtils;
import io.micronaut.transaction.hibernate5.SessionHolder;
import io.micronaut.transaction.jdbc.ConnectionHolder;
import io.micronaut.transaction.jdbc.DataSourceTransactionManager;
import io.micronaut.transaction.jdbc.DataSourceUtils;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import io.micronaut.transaction.jdbc.JdbcTransactionObjectSupport;
import io.micronaut.transaction.support.AbstractSynchronousTransactionManager;
import io.micronaut.transaction.support.DefaultTransactionStatus;
import io.micronaut.transaction.support.ResourceTransactionManager;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.sql.Connection;
import java.time.Duration;
import java.util.Objects;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.transaction.spi.TransactionStatus;

@EachBean(value=SessionFactory.class)
@Requires(missingClasses={"org.springframework.orm.hibernate5.HibernateTransactionManager"})
@Replaces(value=DataSourceTransactionManager.class)
@TypeHint(value={HibernateTransactionManager.class})
public class HibernateTransactionManager
extends AbstractSynchronousTransactionManager<Connection>
implements ResourceTransactionManager<EntityManagerFactory, Connection> {
    @NonNull
    private final SessionFactory sessionFactory;
    @NonNull
    private final DataSource dataSource;
    private boolean prepareConnection = true;
    private boolean allowResultAccessAfterCompletion = false;
    private boolean hibernateManagedSession = false;
    @Nullable
    private final Interceptor entityInterceptor;

    public HibernateTransactionManager(SessionFactory sessionFactory, @Parameter DataSource dataSource, @Nullable Interceptor entityInterceptor) {
        this.sessionFactory = sessionFactory;
        if (dataSource instanceof DelegatingDataSource) {
            dataSource = ((DelegatingDataSource)dataSource).getTargetDataSource();
        }
        this.dataSource = dataSource;
        this.entityInterceptor = entityInterceptor;
    }

    @NonNull
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Nullable
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setAllowResultAccessAfterCompletion(boolean allowResultAccessAfterCompletion) {
        this.allowResultAccessAfterCompletion = allowResultAccessAfterCompletion;
    }

    public void setHibernateManagedSession(boolean hibernateManagedSession) {
        this.hibernateManagedSession = hibernateManagedSession;
    }

    @Nullable
    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public EntityManagerFactory getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Connection getConnection(Object transaction) {
        Session session = ((HibernateTransactionObject)((Object)transaction)).getSessionHolder().getSession();
        return ((SessionImplementor)session).connection();
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionFactory sessionFactory = this.getSessionFactory();
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound Session [" + sessionHolder.getSession() + "] for Hibernate transaction");
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.hibernateManagedSession) {
            Session session = sessionFactory.getCurrentSession();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found Hibernate-managed Session [" + session + "] for Spring-managed transaction");
            }
            txObject.setExistingSession(session);
        }
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
        txObject.setConnectionHolder(conHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        return txObject.hasSpringManagedTransaction() || this.hibernateManagedSession && txObject.hasHibernateManagedTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        Session session = null;
        try {
            Transaction hibTx;
            Duration timeout;
            FlushMode flushMode;
            boolean isolationLevelNeeded;
            if (!txObject.hasSessionHolder() || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                Session newSession;
                Interceptor entityInterceptor = this.getEntityInterceptor();
                Session session2 = newSession = entityInterceptor != null ? this.getSessionFactory().withOptions().interceptor(entityInterceptor).openSession() : this.getSessionFactory().openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Opened new Session [" + newSession + "] for Hibernate transaction");
                }
                txObject.setSession(newSession);
            }
            session = txObject.getSessionHolder().getSession();
            boolean holdabilityNeeded = this.allowResultAccessAfterCompletion && !txObject.isNewSession();
            boolean bl = isolationLevelNeeded = definition.getIsolationLevel() != TransactionDefinition.Isolation.DEFAULT;
            if (holdabilityNeeded || isolationLevelNeeded || definition.isReadOnly()) {
                if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                    int currentHoldability;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Preparing JDBC Connection of Hibernate Session [" + session + "]");
                    }
                    Connection con = ((SessionImplementor)session).connection();
                    TransactionDefinition.Isolation previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
                    txObject.setPreviousIsolationLevel(previousIsolationLevel);
                    if (this.allowResultAccessAfterCompletion && !txObject.isNewSession() && (currentHoldability = con.getHoldability()) != 1) {
                        txObject.setPreviousHoldability(currentHoldability);
                        con.setHoldability(1);
                    }
                } else {
                    if (isolationLevelNeeded) {
                        throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (the default for JDBC).");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Not preparing JDBC Connection of Hibernate Session [" + session + "]");
                    }
                }
            }
            if (definition.isReadOnly() && txObject.isNewSession()) {
                session.setFlushMode(FlushMode.MANUAL);
                session.setDefaultReadOnly(true);
            }
            if (!definition.isReadOnly() && !txObject.isNewSession() && FlushMode.MANUAL.equals((Object)(flushMode = session.getHibernateFlushMode()))) {
                session.setFlushMode(FlushMode.AUTO);
                txObject.getSessionHolder().setPreviousFlushMode(flushMode);
            }
            if ((timeout = this.determineTimeout(definition)) != TransactionDefinition.TIMEOUT_DEFAULT) {
                hibTx = session.getTransaction();
                hibTx.setTimeout((int)timeout.toMillis() / 1000);
                hibTx.begin();
            } else {
                hibTx = session.beginTransaction();
            }
            txObject.getSessionHolder().setTransaction(hibTx);
            if (this.getDataSource() != null) {
                SessionImplementor sessionImpl = (SessionImplementor)session;
                ConnectionHolder conHolder = new ConnectionHolder(() -> ((SessionImplementor)sessionImpl).connection());
                if (timeout != TransactionDefinition.TIMEOUT_DEFAULT) {
                    conHolder.setTimeout(timeout);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exposing Hibernate transaction as JDBC [" + conHolder.getConnectionHandle() + "]");
                }
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Throwable ex) {
            if (txObject.isNewSession()) {
                block25: {
                    try {
                        if (session == null || session.getTransaction().getStatus() != TransactionStatus.ACTIVE) break block25;
                        session.getTransaction().rollback();
                    }
                    catch (Throwable ex2) {
                        try {
                            this.logger.debug("Could not rollback Session after failed transaction begin", ex);
                        }
                        catch (Throwable throwable) {
                            SessionFactoryUtils.closeSession(session);
                            txObject.setSessionHolder(null);
                            throw throwable;
                        }
                        SessionFactoryUtils.closeSession(session);
                        txObject.setSessionHolder(null);
                    }
                }
                SessionFactoryUtils.closeSession(session);
                txObject.setSessionHolder(null);
            }
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        SessionFactory sessionFactory = this.getSessionFactory();
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
        }
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)resourcesHolder.getSessionHolder()));
        if (this.getDataSource() != null && resourcesHolder.getConnectionHolder() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        Transaction hibTx = txObject.getSessionHolder().getTransaction();
        Objects.requireNonNull(hibTx, "No Hibernate transaction");
        if (status.isDebug()) {
            this.logger.debug("Committing Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "]");
        }
        try {
            hibTx.commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        Transaction hibTx = txObject.getSessionHolder().getTransaction();
        Objects.requireNonNull(hibTx, "No Hibernate transaction");
        if (status.isDebug()) {
            this.logger.debug("Rolling back Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "]");
        }
        try {
            hibTx.rollback();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not roll back Hibernate transaction", (Throwable)ex);
        }
        finally {
            if (!txObject.isNewSession() && !this.hibernateManagedSession) {
                txObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug("Setting Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "] rollback-only");
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        Session session = txObject.getSessionHolder().getSession();
        if (this.prepareConnection && this.isPhysicallyConnected(session)) {
            try {
                Connection con = ((SessionImplementor)session).connection();
                Integer previousHoldability = txObject.getPreviousHoldability();
                if (previousHoldability != null) {
                    con.setHoldability(previousHoldability);
                }
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (TransactionDefinition.Isolation)txObject.getPreviousIsolationLevel());
            }
            catch (HibernateException ex) {
                this.logger.debug("Could not access JDBC Connection of Hibernate Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                this.logger.debug("Could not reset JDBC Connection after transaction", ex);
            }
        }
        if (txObject.isNewSession()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing Hibernate Session [" + session + "] after transaction");
            }
            SessionFactoryUtils.closeSession(session);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Not closing pre-bound Hibernate Session [" + session + "] after transaction");
            }
            if (txObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getSessionHolder().getPreviousFlushMode());
            }
            if (!this.allowResultAccessAfterCompletion && !this.hibernateManagedSession) {
                this.disconnectOnCompletion(session);
            }
        }
        txObject.getSessionHolder().clear();
    }

    protected void disconnectOnCompletion(Session session) {
        session.disconnect();
    }

    protected boolean isSameConnectionForEntireSession(Session session) {
        if (!(session instanceof SessionImplementor)) {
            return true;
        }
        PhysicalConnectionHandlingMode releaseMode = ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode();
        return PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_HOLD.equals((Object)releaseMode);
    }

    protected boolean isPhysicallyConnected(Session session) {
        if (!(session instanceof SessionImplementor)) {
            return session.isConnected();
        }
        return ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected();
    }

    @NonNull
    public Connection getConnection() {
        Session currentSession = this.sessionFactory.getCurrentSession();
        return ((SessionImplementor)currentSession).connection();
    }

    private static final class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        @Nullable
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, @Nullable ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        @Nullable
        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        @Nullable
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;
        private boolean newSession;
        @Nullable
        private Integer previousHoldability;

        private HibernateTransactionObject() {
        }

        public void setSession(Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = true;
        }

        public void setExistingSession(Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = false;
        }

        public void setSessionHolder(@Nullable SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = false;
            this.newSession = false;
        }

        public SessionHolder getSessionHolder() {
            Objects.requireNonNull(this.sessionHolder, "No SessionHolder available");
            return this.sessionHolder;
        }

        public boolean hasSessionHolder() {
            return this.sessionHolder != null;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean isNewSession() {
            return this.newSession;
        }

        public void setPreviousHoldability(@Nullable Integer previousHoldability) {
            this.previousHoldability = previousHoldability;
        }

        @Nullable
        public Integer getPreviousHoldability() {
            return this.previousHoldability;
        }

        public boolean hasSpringManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public boolean hasHibernateManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getSession().getTransaction().getStatus() == TransactionStatus.ACTIVE;
        }

        public void setRollbackOnly() {
            this.getSessionHolder().setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            this.getSessionHolder().getSession().flush();
        }
    }
}

