/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate5;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.Ordered;
import io.micronaut.transaction.exceptions.TransactionException;
import io.micronaut.transaction.hibernate5.SessionFactoryUtils;
import io.micronaut.transaction.hibernate5.SessionHolder;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@Internal
public class SessionSynchronization
implements TransactionSynchronization,
Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final boolean newSession;
    private boolean holderActive = true;

    SessionSynchronization(@NonNull SessionHolder sessionHolder, @NonNull SessionFactory sessionFactory, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.newSession = newSession;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.getCurrentSession().disconnect();
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void flush() {
        SessionFactoryUtils.flush(this.getCurrentSession(), false);
    }

    public void beforeCommit(boolean readOnly) throws TransactionException {
        Session session;
        if (!readOnly && !FlushMode.MANUAL.equals((Object)(session = this.getCurrentSession()).getHibernateFlushMode())) {
            SessionFactoryUtils.flush(this.getCurrentSession(), true);
        }
    }

    public void beforeCompletion() {
        try {
            Session session = this.sessionHolder.getSession();
            if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            session.disconnect();
        }
        finally {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                this.holderActive = false;
            }
        }
    }

    public void afterCommit() {
    }

    public void afterCompletion(@NonNull TransactionSynchronization.Status status) {
        try {
            if (status != TransactionSynchronization.Status.COMMITTED) {
                this.sessionHolder.getSession().clear();
            }
        }
        finally {
            this.sessionHolder.setSynchronizedWithTransaction(false);
            if (this.newSession) {
                SessionFactoryUtils.closeSession(this.sessionHolder.getSession());
            }
        }
    }
}

