/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate5;

import io.micronaut.core.annotation.TypeHint;
import io.micronaut.transaction.hibernate5.SessionHolder;
import io.micronaut.transaction.hibernate5.SessionSynchronization;
import io.micronaut.transaction.jpa.EntityManagerHolder;
import io.micronaut.transaction.support.SynchronousTransactionState;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;

@TypeHint(value={MicronautSessionContext.class})
public final class MicronautSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor sessionFactory;

    public MicronautSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SynchronousTransactionState state;
            SessionHolder sessionHolder = (SessionHolder)((Object)value);
            Session session = sessionHolder.getSession();
            if (!sessionHolder.isSynchronizedWithTransaction() && (state = TransactionSynchronizationManager.getSynchronousTransactionState((Object)this.sessionFactory)) != null && state.isSynchronizationActive()) {
                state.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory, false));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getHibernateFlushMode();
                if (flushMode.equals((Object)FlushMode.MANUAL) && !state.isTransactionReadOnly()) {
                    session.setFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (value instanceof EntityManagerHolder) {
            return (Session)((EntityManagerHolder)((Object)value)).getEntityManager().unwrap(Session.class);
        }
        SynchronousTransactionState state = TransactionSynchronizationManager.getSynchronousTransactionState((Object)this.sessionFactory);
        if (state == null || !state.isSynchronizationActive()) {
            throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
        }
        Session session = this.sessionFactory.openSession();
        if (state.isTransactionReadOnly()) {
            session.setFlushMode(FlushMode.MANUAL);
        }
        SessionHolder sessionHolder = new SessionHolder(session);
        state.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory, true));
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)sessionHolder));
        sessionHolder.setSynchronizedWithTransaction(true);
        return session;
    }
}

