/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jpa;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.SavepointManager;
import io.micronaut.transaction.support.ResourceHolderSupport;
import java.util.Objects;
import javax.persistence.EntityManager;

public class EntityManagerHolder
extends ResourceHolderSupport {
    @Nullable
    private final EntityManager entityManager;
    private boolean transactionActive;
    @Nullable
    private SavepointManager savepointManager;

    public EntityManagerHolder(@Nullable EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @NonNull
    public EntityManager getEntityManager() {
        Objects.requireNonNull(this.entityManager, "No EntityManager available");
        return this.entityManager;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setSavepointManager(@Nullable SavepointManager savepointManager) {
        this.savepointManager = savepointManager;
    }

    @Nullable
    protected SavepointManager getSavepointManager() {
        return this.savepointManager;
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
        this.savepointManager = null;
    }
}

