/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.data.connection.support.JdbcConnectionUtils;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.CannotCreateTransactionException;
import io.micronaut.transaction.exceptions.InvalidIsolationLevelException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.hibernate.HibernateTransactionManagerCondition;
import io.micronaut.transaction.impl.DefaultTransactionStatus;
import io.micronaut.transaction.jdbc.DataSourceTransactionManager;
import io.micronaut.transaction.support.AbstractDefaultTransactionOperations;
import io.micronaut.transaction.support.TransactionSynchronization;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.slf4j.Logger;

@EachBean(value=DataSource.class)
@Replaces(value=DataSourceTransactionManager.class)
@Requires(condition=HibernateTransactionManagerCondition.class)
@TypeHint(value={HibernateTransactionManager.class})
public final class HibernateTransactionManager
extends AbstractDefaultTransactionOperations<Session> {
    private boolean prepareConnection = true;
    private boolean allowResultAccessAfterCompletion = false;

    HibernateTransactionManager(@Parameter ConnectionOperations<Session> connectionOperations, @Parameter SynchronousConnectionManager<Session> synchronousConnectionManager) {
        super(connectionOperations, synchronousConnectionManager);
    }

    protected void doBegin(DefaultTransactionStatus<Session> txStatus) {
        FlushMode flushMode;
        final Session session = (Session)txStatus.getConnection();
        TransactionDefinition definition = txStatus.getTransactionDefinition();
        boolean isNewSession = txStatus.getConnectionStatus().isNew();
        boolean isReadOnly = definition.isReadOnly().orElse(false);
        if (isReadOnly && isNewSession) {
            session.setFlushMode(FlushMode.MANUAL.toJpaFlushMode());
            session.setDefaultReadOnly(true);
        }
        final ArrayList onComplete = new ArrayList(5);
        boolean holdabilityNeeded = this.allowResultAccessAfterCompletion && !isNewSession;
        boolean isolationLevelNeeded = definition.getIsolationLevel().isPresent();
        if (holdabilityNeeded || isolationLevelNeeded || definition.isReadOnly().isPresent()) {
            if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Preparing JDBC Connection of Hibernate Session [{}]", (Object)session);
                }
                Connection connection = this.getConnection(session);
                definition.isReadOnly().ifPresent(readOnly -> JdbcConnectionUtils.applyReadOnly((Logger)this.logger, (Connection)connection, (boolean)readOnly, (List)onComplete));
                definition.getIsolationLevel().ifPresent(isolation -> JdbcConnectionUtils.applyTransactionIsolation((Logger)this.logger, (Connection)connection, (int)isolation.getCode(), (List)onComplete));
                if (this.allowResultAccessAfterCompletion && !isNewSession) {
                    JdbcConnectionUtils.applyHoldability((Logger)this.logger, (Connection)connection, (int)1, onComplete);
                }
            } else {
                if (isolationLevelNeeded) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (the default for JDBC).");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not preparing JDBC Connection of Hibernate Session [{}]", (Object)session);
                }
            }
        }
        if (!isReadOnly && !isNewSession && FlushMode.MANUAL.equals((Object)(flushMode = session.getHibernateFlushMode()))) {
            session.setFlushMode(FlushMode.AUTO.toJpaFlushMode());
            txStatus.registerInvocationSynchronization(new TransactionSynchronization(){

                public void beforeCompletion() {
                    session.setFlushMode(flushMode.toJpaFlushMode());
                }
            });
        }
        this.determineTimeout(definition).ifPresent(timeout -> {
            Transaction hibTx = session.getTransaction();
            hibTx.setTimeout((int)timeout.toMillis() / 1000);
        });
        if (!onComplete.isEmpty()) {
            Collections.reverse(onComplete);
            txStatus.registerInvocationSynchronization(new TransactionSynchronization(){

                public void afterCompletion(TransactionSynchronization.Status status) {
                    if (HibernateTransactionManager.this.isPhysicallyConnected(session)) {
                        for (Runnable runnable : onComplete) {
                            runnable.run();
                        }
                    }
                }
            });
        }
        Transaction transaction = session.beginTransaction();
        txStatus.setTransaction((Object)transaction);
    }

    protected void doCommit(DefaultTransactionStatus<Session> tx) {
        Transaction transaction = (Transaction)tx.getTransaction();
        Objects.requireNonNull(transaction, "No Hibernate transaction");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Committing Hibernate transaction on Session [{}]", tx.getConnection());
        }
        try {
            transaction.commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", (Throwable)ex);
        }
        catch (PersistenceException ex) {
            if (ex.getCause() instanceof HibernateException) {
                throw ex;
            }
            throw ex;
        }
    }

    protected void doRollback(DefaultTransactionStatus<Session> tx) {
        Transaction transaction = (Transaction)tx.getTransaction();
        Objects.requireNonNull(transaction, "No Hibernate transaction");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rolling back Hibernate transaction on Session [{}]", tx.getConnection());
        }
        try {
            transaction.rollback();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not roll back Hibernate transaction", (Throwable)ex);
        }
        finally {
            if (!tx.getConnectionStatus().isNew()) {
                ((Session)tx.getConnection()).clear();
            }
        }
    }

    protected void doNestedBegin(DefaultTransactionStatus<Session> status) {
        try {
            Session session = (Session)status.getConnection();
            Savepoint savepoint = this.getConnection(session).setSavepoint(status.getTransactionDefinition().getName());
            status.setSavepoint((Object)savepoint);
        }
        catch (SQLException e) {
            throw new CannotCreateTransactionException("Could not create JDBC savepoint", (Throwable)e);
        }
    }

    protected void doNestedCommit(DefaultTransactionStatus<Session> status) {
        if (status.getSavepoint() != null) {
            Session session = (Session)status.getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Releasing JDBC savepoint for Session [{}]", (Object)session);
            }
            try {
                this.getConnection(session).releaseSavepoint((Savepoint)status.getSavepoint());
            }
            catch (Exception e) {
                throw new TransactionSystemException("Could release JDBC savepoint", (Throwable)e);
            }
        } else {
            throw new TransactionSystemException("Missing a JDBC savepoint");
        }
    }

    protected void doNestedRollback(DefaultTransactionStatus<Session> status) {
        if (status.getSavepoint() != null) {
            Session session = (Session)status.getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolling back JDBC transaction to the savepoint for Session [{}]", (Object)session);
            }
            try {
                this.getConnection(session).rollback((Savepoint)status.getSavepoint());
            }
            catch (Exception e) {
                throw new TransactionSystemException("Could not roll back to JDBC savepoint", (Throwable)e);
            }
        } else {
            throw new TransactionSystemException("Missing a JDBC savepoint");
        }
    }

    @NonNull
    public Session getConnection() {
        return (Session)this.connectionOperations.getConnectionStatus().getConnection();
    }

    @NonNull
    public boolean hasConnection() {
        return this.connectionOperations.findConnectionStatus().isPresent();
    }

    private boolean isSameConnectionForEntireSession(Session session) {
        if (!(session instanceof SessionImplementor)) {
            return true;
        }
        PhysicalConnectionHandlingMode releaseMode = ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode();
        return PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_HOLD.equals((Object)releaseMode);
    }

    private boolean isPhysicallyConnected(Session session) {
        if (!(session instanceof SessionImplementor)) {
            return session.isConnected();
        }
        return ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected();
    }

    private Connection getConnection(Session session) {
        return ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
    }
}

