/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jdbc;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionSynchronization;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.connection.support.JdbcConnectionUtils;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.CannotCreateTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.impl.DefaultTransactionStatus;
import io.micronaut.transaction.jdbc.JdbcTransactionManagerCondition;
import io.micronaut.transaction.support.AbstractDefaultTransactionOperations;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;

@Internal
@EachBean(value=DataSource.class)
@Requires(condition=JdbcTransactionManagerCondition.class)
@TypeHint(value={DataSourceTransactionManager.class})
public final class DataSourceTransactionManager
extends AbstractDefaultTransactionOperations<Connection> {
    private final DataSource dataSource;
    private boolean enforceReadOnly = false;

    public DataSourceTransactionManager(@NonNull DataSource dataSource, @Parameter ConnectionOperations<Connection> connectionOperations, @Parameter @Nullable SynchronousConnectionManager<Connection> synchronousConnectionManager) {
        super(connectionOperations, synchronousConnectionManager);
        Objects.requireNonNull(dataSource, "DataSource cannot be null");
        this.dataSource = dataSource = DelegatingDataSource.unwrapDataSource((DataSource)dataSource);
    }

    @NonNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setEnforceReadOnly(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public boolean isEnforceReadOnly() {
        return this.enforceReadOnly;
    }

    protected void doBegin(DefaultTransactionStatus<Connection> status) {
        TransactionDefinition definition = status.getTransactionDefinition();
        Connection connection = (Connection)status.getConnection();
        final ArrayList onComplete = new ArrayList(5);
        definition.isReadOnly().ifPresent(readOnly -> JdbcConnectionUtils.applyReadOnly((Logger)this.logger, (Connection)connection, (boolean)readOnly, (List)onComplete));
        definition.getIsolationLevel().ifPresent(isolation -> JdbcConnectionUtils.applyTransactionIsolation((Logger)this.logger, (Connection)connection, (int)isolation.getCode(), (List)onComplete));
        JdbcConnectionUtils.applyAutoCommit((Logger)this.logger, (Connection)connection, (boolean)false, onComplete);
        if (!onComplete.isEmpty()) {
            Collections.reverse(onComplete);
            status.getConnectionStatus().registerSynchronization(new ConnectionSynchronization(){

                public void executionComplete() {
                    for (Runnable runnable : onComplete) {
                        runnable.run();
                    }
                }
            });
        }
    }

    protected void doCommit(DefaultTransactionStatus<Connection> status) {
        Connection connection = (Connection)status.getConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Committing JDBC transaction on Connection [{}]", (Object)connection);
        }
        try {
            connection.commit();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not commit JDBC transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus<Connection> status) {
        Connection connection = (Connection)status.getConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rolling back JDBC transaction on Connection [{}]", (Object)connection);
        }
        try {
            connection.rollback();
        }
        catch (SQLException ex) {
            throw new TransactionSystemException("Could not roll back JDBC transaction", (Throwable)ex);
        }
    }

    protected void doNestedBegin(DefaultTransactionStatus<Connection> status) {
        try {
            Connection connection = (Connection)status.getConnection();
            Savepoint savepoint = connection.setSavepoint(status.getTransactionDefinition().getName());
            status.setSavepoint((Object)savepoint);
        }
        catch (SQLException e) {
            throw new CannotCreateTransactionException("Could not create JDBC savepoint", (Throwable)e);
        }
    }

    protected void doNestedCommit(DefaultTransactionStatus<Connection> status) {
        if (status.getSavepoint() != null) {
            Connection connection = (Connection)status.getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Releasing JDBC savepoint on Connection [{}]", (Object)connection);
            }
            try {
                connection.releaseSavepoint((Savepoint)status.getSavepoint());
            }
            catch (Exception e) {
                throw new TransactionSystemException("Could release JDBC savepoint", (Throwable)e);
            }
        } else {
            throw new TransactionSystemException("Missing a JDBC savepoint");
        }
    }

    protected void doNestedRollback(DefaultTransactionStatus<Connection> status) {
        if (status.getSavepoint() != null) {
            Connection connection = (Connection)status.getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolling back JDBC transaction to the savepoint on Connection [{}]", (Object)connection);
            }
            try {
                connection.rollback((Savepoint)status.getSavepoint());
            }
            catch (Exception e) {
                throw new TransactionSystemException("Could not roll back to JDBC savepoint", (Throwable)e);
            }
        } else {
            throw new TransactionSystemException("Missing a JDBC savepoint");
        }
    }

    protected void prepareTransactionalConnection(Connection con, TransactionDefinition definition) throws SQLException {
        if (this.isEnforceReadOnly() && definition.isReadOnly().orElse(false).booleanValue()) {
            try (Statement stmt = con.createStatement();){
                stmt.executeUpdate("SET TRANSACTION READ ONLY");
            }
        }
    }

    @NonNull
    public Connection getConnection() {
        return (Connection)this.connectionOperations.getConnectionStatus().getConnection();
    }
}

