/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.interceptor.DefaultTransactionAttribute;
import io.micronaut.transaction.interceptor.TransactionAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={SynchronousTransactionManager.class})
public class TransactionalInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalInterceptor.class);
    private static final ThreadLocal<TransactionInfo> TRANSACTION_INFO_HOLDER = new ThreadLocal(){

        public String toString() {
            return "Current aspect-driven transaction";
        }
    };
    private final Map<ExecutableMethod, TransactionInvocation> transactionInvocationMap = new ConcurrentHashMap<ExecutableMethod, TransactionInvocation>(30);
    @NonNull
    private final BeanLocator beanLocator;

    public TransactionalInterceptor(@NonNull BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Object retVal;
        TransactionInvocation transactionInvocation = this.transactionInvocationMap.computeIfAbsent(context.getExecutableMethod(), executableMethod -> {
            String qualifier = executableMethod.stringValue(TransactionalAdvice.class).orElse(null);
            SynchronousTransactionManager transactionManager = (SynchronousTransactionManager)this.beanLocator.getBean(SynchronousTransactionManager.class, qualifier != null ? Qualifiers.byName((String)qualifier) : null);
            TransactionAttribute transactionAttribute = this.resolveTransactionDefinition((ExecutableMethod<Object, Object>)executableMethod);
            return new TransactionInvocation(transactionManager, transactionAttribute);
        });
        TransactionAttribute definition = transactionInvocation.definition;
        SynchronousTransactionManager transactionManager = transactionInvocation.transactionManager;
        TransactionInfo transactionInfo = this.createTransactionIfNecessary(transactionManager, definition, definition.getName());
        try {
            retVal = context.proceed();
        }
        catch (Throwable ex) {
            this.completeTransactionAfterThrowing(transactionInfo, ex);
            throw ex;
        }
        finally {
            this.cleanupTransactionInfo(transactionInfo);
        }
        this.commitTransactionAfterReturning(transactionInfo);
        return retVal;
    }

    @Nullable
    private static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        return TRANSACTION_INFO_HOLDER.get();
    }

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        TransactionInfo info = TransactionalInterceptor.currentTransactionInfo();
        if (info == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info.transactionStatus;
    }

    protected TransactionInfo createTransactionIfNecessary(@NonNull SynchronousTransactionManager tm, @NonNull TransactionAttribute txAttr, String joinpointIdentification) {
        TransactionStatus status = tm.getTransaction(txAttr);
        return this.prepareTransactionInfo(tm, txAttr, joinpointIdentification, status);
    }

    protected TransactionInfo prepareTransactionInfo(@NonNull SynchronousTransactionManager tm, @NonNull TransactionAttribute txAttr, String joinpointIdentification, @NonNull TransactionStatus status) {
        TransactionInfo txInfo = new TransactionInfo(tm, txAttr, joinpointIdentification);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting transaction for [" + txInfo.getJoinpointIdentification() + "]");
        }
        txInfo.newTransactionStatus(status);
        txInfo.bindToThread();
        return txInfo;
    }

    protected void commitTransactionAfterReturning(@NonNull TransactionInfo txInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Completing transaction for [" + txInfo.getJoinpointIdentification() + "]");
        }
        txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
    }

    protected void completeTransactionAfterThrowing(@NonNull TransactionInfo txInfo, Throwable ex) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Completing transaction for [" + txInfo.getJoinpointIdentification() + "] after exception: " + ex);
        }
        if (txInfo.transactionAttribute.rollbackOn(ex)) {
            try {
                txInfo.getTransactionManager().rollback(txInfo.getTransactionStatus());
            }
            catch (TransactionSystemException ex2) {
                LOG.error("Application exception overridden by rollback exception", ex);
                ex2.initApplicationException(ex);
                throw ex2;
            }
            catch (Error | RuntimeException ex2) {
                LOG.error("Application exception overridden by rollback exception", ex);
                throw ex2;
            }
        }
        try {
            txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
        }
        catch (TransactionSystemException ex2) {
            LOG.error("Application exception overridden by commit exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (Error | RuntimeException ex2) {
            LOG.error("Application exception overridden by commit exception", ex);
            throw ex2;
        }
    }

    protected void cleanupTransactionInfo(@Nullable TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    protected TransactionAttribute resolveTransactionDefinition(ExecutableMethod<Object, Object> executableMethod) {
        AnnotationValue annotation = executableMethod.getAnnotation(TransactionalAdvice.class);
        if (annotation == null) {
            throw new IllegalStateException("No declared @Transactional annotation present");
        }
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setName(executableMethod.getDeclaringType().getSimpleName() + "." + executableMethod.getMethodName());
        attribute.setReadOnly(annotation.isTrue("readOnly"));
        annotation.intValue("timeout").ifPresent(value -> attribute.setTimeout(Duration.ofSeconds(value)));
        Class[] noRollbackFors = annotation.classValues("noRollbackFor");
        attribute.setNoRollbackFor(noRollbackFors);
        annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(attribute::setPropagationBehavior);
        annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(attribute::setIsolationLevel);
        return attribute;
    }

    protected final class TransactionInfo {
        private final SynchronousTransactionManager transactionManager;
        private final TransactionAttribute transactionAttribute;
        private final String joinpointIdentification;
        @NonNull
        private TransactionStatus transactionStatus;
        @NonNull
        private TransactionInfo oldTransactionInfo;

        protected TransactionInfo(@NonNull SynchronousTransactionManager transactionManager, @NonNull TransactionAttribute transactionAttribute, String joinpointIdentification) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.joinpointIdentification = joinpointIdentification;
        }

        @NonNull
        public SynchronousTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        @NonNull
        public String getJoinpointIdentification() {
            return this.joinpointIdentification;
        }

        public void newTransactionStatus(@NonNull TransactionStatus status) {
            this.transactionStatus = status;
        }

        @NonNull
        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public boolean hasTransaction() {
            return true;
        }

        private void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)TRANSACTION_INFO_HOLDER.get();
            TRANSACTION_INFO_HOLDER.set(this);
        }

        private void restoreThreadLocalStatus() {
            TRANSACTION_INFO_HOLDER.set(this.oldTransactionInfo);
        }

        public String toString() {
            return this.transactionAttribute.toString();
        }
    }

    private final class TransactionInvocation {
        final SynchronousTransactionManager transactionManager;
        final TransactionAttribute definition;

        TransactionInvocation(SynchronousTransactionManager transactionManager, TransactionAttribute definition) {
            this.transactionManager = transactionManager;
            this.definition = definition;
        }
    }
}

