/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jdbc;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DelegatingDataSource
implements DataSource {
    @NonNull
    private final DataSource targetDataSource;

    public DelegatingDataSource(@NonNull DataSource targetDataSource) {
        Objects.requireNonNull(targetDataSource, "The target data source cannot be null");
        this.targetDataSource = targetDataSource;
    }

    @NonNull
    public final DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getTargetDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getTargetDataSource().setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getTargetDataSource().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getTargetDataSource().setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.getTargetDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.getTargetDataSource().isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @NonNull
    public static DataSource unwrapDataSource(@NonNull DataSource dataSource) {
        while (dataSource instanceof DelegatingDataSource) {
            dataSource = ((DelegatingDataSource)dataSource).getTargetDataSource();
        }
        return dataSource;
    }
}

