/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.spring.tx.test.SpringTransactionTestExecutionListener;
import io.micronaut.test.annotation.TransactionMode;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.test.DefaultTestSingleTransactionExecutionListener;
import jakarta.inject.Provider;

@EachBean(value=SynchronousTransactionManager.class)
@Requirements(value={@Requires(classes={TestExecutionListener.class}), @Requires(property="micronaut.test.transactional", value="true", defaultValue="true")})
@Replaces(value=SpringTransactionTestExecutionListener.class)
@Internal
public class DefaultTestTransactionExecutionListener
implements TestExecutionListener {
    private final TestExecutionListener delegate;

    DefaultTestTransactionExecutionListener(Provider<SynchronousTransactionManager<Object>> transactionManagerProvider, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback, @Property(name="micronaut.test.transaction-mode", defaultValue="SEPARATE_TRANSACTIONS") TransactionMode transactionMode) {
        if (transactionMode == TransactionMode.SINGLE_TRANSACTION) {
            SynchronousTransactionManager transactionManager = (SynchronousTransactionManager)transactionManagerProvider.get();
            this.delegate = new DefaultTestSingleTransactionExecutionListener(transactionManager, rollback);
        } else {
            this.delegate = new NoopTestExecutionListener();
        }
    }

    public void beforeSetupTest(TestContext testContext) throws Exception {
        this.delegate.beforeSetupTest(testContext);
    }

    public void afterSetupTest(TestContext testContext) throws Exception {
        this.delegate.afterSetupTest(testContext);
    }

    public void beforeCleanupTest(TestContext testContext) throws Exception {
        this.delegate.beforeCleanupTest(testContext);
    }

    public void afterCleanupTest(TestContext testContext) throws Exception {
        this.delegate.afterCleanupTest(testContext);
    }

    public void beforeTestExecution(TestContext testContext) throws Exception {
        this.delegate.beforeTestExecution(testContext);
    }

    public void afterTestExecution(TestContext testContext) throws Exception {
        this.delegate.afterTestExecution(testContext);
    }

    private static final class NoopTestExecutionListener
    implements TestExecutionListener {
        private NoopTestExecutionListener() {
        }
    }
}

