/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.kotlin.KotlinInterceptedMethod;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.interceptor.TxSynchronousContext;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import jakarta.inject.Singleton;
import kotlin.coroutines.CoroutineContext;

@Internal
@Singleton
@Requires(classes={CoroutineContext.class})
public final class CoroutineTxHelper {
    public void setupTxState(KotlinInterceptedMethod kotlinInterceptedMethod, TransactionSynchronizationManager.TransactionSynchronizationState state) {
        CoroutineContext coroutineContext = kotlinInterceptedMethod.getCoroutineContext().minusKey((CoroutineContext.Key)TxSynchronousContext.Key).plus((CoroutineContext)new TxSynchronousContext(state));
        kotlinInterceptedMethod.updateCoroutineContext(coroutineContext);
    }

    @Nullable
    public TransactionSynchronizationManager.TransactionSynchronizationState getTxState(@NonNull KotlinInterceptedMethod kotlinInterceptedMethod) {
        TxSynchronousContext txSynchronousContext = (TxSynchronousContext)kotlinInterceptedMethod.getCoroutineContext().get((CoroutineContext.Key)TxSynchronousContext.Key);
        return txSynchronousContext != null ? txSynchronousContext.getState() : TransactionSynchronizationManager.getState();
    }
}

