/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import java.util.Optional;

@Blocking
public interface TransactionOperations<T> {
    @NonNull
    public T getConnection();

    public boolean hasConnection();

    public Optional<? extends TransactionStatus<?>> findTransactionStatus();

    public <R> R execute(@NonNull TransactionDefinition var1, @NonNull TransactionCallback<T, R> var2);

    default public <R> R executeRead(@NonNull TransactionCallback<T, R> callback) {
        return this.execute(TransactionDefinition.READ_ONLY, callback);
    }

    default public <R> R executeWrite(@NonNull TransactionCallback<T, R> callback) {
        return this.execute(TransactionDefinition.DEFAULT, callback);
    }
}

