/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import java.util.Optional;

public abstract class AbstractPropagatedStatusTransactionOperations<T extends TransactionStatus<C>, C>
implements TransactionOperations<C> {
    protected abstract <R> R doExecute(TransactionDefinition var1, TransactionCallback<C, R> var2);

    @Override
    public final Optional<T> findTransactionStatus() {
        return this.findTransactionPropagatedContextElement().map(PropagatedTransactionStatusElement::status).map(status -> status);
    }

    private Optional<PropagatedTransactionStatusElement> findTransactionPropagatedContextElement() {
        return PropagatedContext.getOrEmpty().findAll(PropagatedTransactionStatusElement.class).filter(element -> element.transactionOperations == this).findFirst();
    }

    @Override
    public final <R> R execute(@NonNull TransactionDefinition definition, @NonNull TransactionCallback<C, R> callback) {
        return (R)this.doExecute(definition, status -> {
            try (PropagatedContext.Scope ignore = this.extendCurrentPropagatedContext(status).propagate();){
                Object r = callback.call(status);
                return r;
            }
        });
    }

    @NonNull
    protected PropagatedContext extendCurrentPropagatedContext(TransactionStatus<C> status) {
        return PropagatedContext.getOrEmpty().plus(new PropagatedTransactionStatusElement(this, status));
    }

    private record PropagatedTransactionStatusElement<T extends TransactionStatus<?>>(TransactionOperations<?> transactionOperations, TransactionStatus<?> status) implements PropagatedContextElement
    {
    }
}

