/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.annotation.Transactional;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.time.Duration;
import java.util.Arrays;

@Internal
public final class TransactionUtil {
    private TransactionUtil() {
    }

    @NonNull
    public static TransactionDefinition getTransactionDefinition(String name, AnnotationMetadataProvider annotationMetadataProvider) {
        AnnotationValue annotation = annotationMetadataProvider.getAnnotation(Transactional.class);
        if (annotation == null) {
            return TransactionDefinition.DEFAULT;
        }
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setName(name);
        definition.setReadOnly(annotation.isTrue("readOnly"));
        annotation.intValue("timeout").ifPresent(value -> definition.setTimeout(Duration.ofSeconds(value)));
        Class[] rollbackFor = annotation.classValues("rollbackFor");
        definition.setRollbackOn(Arrays.asList(rollbackFor));
        Class[] noRollbackFors = annotation.classValues("noRollbackFor");
        definition.setDontRollbackOn(Arrays.asList(noRollbackFors));
        annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(definition::setPropagationBehavior);
        annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(definition::setIsolationLevel);
        return definition;
    }
}

