/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.transaction.impl.InternalTransaction;
import io.micronaut.transaction.support.TransactionSynchronization;
import java.util.ArrayList;
import java.util.List;

@Internal
public abstract class AbstractInternalTransaction<C>
implements InternalTransaction<C> {
    protected List<TransactionSynchronization> synchronizations;
    private boolean manualRollbackOnly = false;
    private boolean globalRollbackOnly = false;
    private boolean completed = false;

    protected void setGlobalRollbackOnly() {
        this.globalRollbackOnly = true;
    }

    @Override
    public void setRollbackOnly() {
        this.manualRollbackOnly = true;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.isLocalRollbackOnly() || this.isGlobalRollbackOnly();
    }

    @Override
    public boolean isLocalRollbackOnly() {
        return this.manualRollbackOnly;
    }

    @Override
    public boolean isGlobalRollbackOnly() {
        return this.globalRollbackOnly;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void triggerBeforeCommit() {
        if (this.synchronizations != null) {
            for (TransactionSynchronization synchronization : this.synchronizations) {
                synchronization.beforeCommit(this.getTransactionDefinition().isReadOnly().orElse(false));
            }
        }
    }

    @Override
    public void triggerAfterCommit() {
        if (this.synchronizations != null) {
            for (TransactionSynchronization synchronization : this.synchronizations) {
                synchronization.afterCommit();
            }
        }
    }

    @Override
    public void triggerBeforeCompletion() {
        if (this.synchronizations != null) {
            for (TransactionSynchronization synchronization : this.synchronizations) {
                synchronization.beforeCompletion();
            }
        }
    }

    @Override
    public void triggerAfterCompletion(TransactionSynchronization.Status status) {
        this.completed = true;
        if (this.synchronizations != null) {
            for (TransactionSynchronization synchronization : this.synchronizations) {
                synchronization.afterCompletion(status);
            }
        }
    }

    @Override
    public void cleanupAfterCompletion() {
    }

    @Override
    public void registerSynchronization(@NonNull TransactionSynchronization synchronization) {
        this.registerInvocationSynchronization(synchronization);
    }

    @Override
    public void registerInvocationSynchronization(@NonNull TransactionSynchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<TransactionSynchronization>(5);
        }
        this.synchronizations.add(synchronization);
        OrderUtil.sort(this.synchronizations);
    }
}

