/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.sync;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public final class SynchronousTransactionOperationsFromReactiveTransactionOperations<T>
implements TransactionOperations<T> {
    private final ReactorReactiveTransactionOperations<T> reactiveTransactionOperations;
    private final Scheduler scheduler;

    public SynchronousTransactionOperationsFromReactiveTransactionOperations(ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, ExecutorService blockingExecutorService) {
        this.reactiveTransactionOperations = reactiveTransactionOperations;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)blockingExecutorService);
    }

    @Override
    public T getConnection() {
        throw this.noSupported();
    }

    @Override
    public boolean hasConnection() {
        throw this.noSupported();
    }

    @Override
    public Optional<? extends TransactionStatus<?>> findTransactionStatus() {
        return Optional.empty();
    }

    @Override
    public <R> R execute(TransactionDefinition definition, TransactionCallback<T, R> callback) {
        Mono result = this.reactiveTransactionOperations.withTransactionMono(definition, status -> Mono.deferContextual(contextView -> {
            try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElseGet(PropagatedContext::getOrEmpty).propagate();){
                Mono mono = Mono.justOrEmpty(callback.apply(new DefaultTransactionStatus(status)));
                return mono;
            }
        }).subscribeOn(this.scheduler)).contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)PropagatedContext.getOrEmpty()));
        return (R)result.onErrorMap(e -> {
            if (e instanceof UndeclaredThrowableException) {
                return e.getCause();
            }
            return e;
        }).block();
    }

    @NonNull
    private IllegalStateException noSupported() {
        return new IllegalStateException("This synchronous transaction manager is implemented using blocking of the reactive transaction manager and only supports 'execute', 'executeRead' and 'executeWrite' methods.");
    }

    private final class DefaultTransactionStatus<K>
    implements TransactionStatus<K> {
        private final ReactiveTransactionStatus<K> transactionStatus;

        private DefaultTransactionStatus(ReactiveTransactionStatus<K> transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public boolean isNewTransaction() {
            return this.transactionStatus.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.transactionStatus.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.transactionStatus.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.transactionStatus.isCompleted();
        }

        @Override
        public TransactionDefinition getTransactionDefinition() {
            return this.transactionStatus.getTransactionDefinition();
        }

        @Override
        public Object getTransaction() {
            throw SynchronousTransactionOperationsFromReactiveTransactionOperations.this.noSupported();
        }

        @Override
        public K getConnection() {
            throw SynchronousTransactionOperationsFromReactiveTransactionOperations.this.noSupported();
        }

        @Override
        public ConnectionStatus<K> getConnectionStatus() {
            return this.transactionStatus.getConnectionStatus();
        }
    }
}

