/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.parameterstore;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementAsync;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementAsyncClient;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementAsyncClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathResult;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import io.micronaut.configuration.aws.AWSClientConfiguration;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.aws.parameterstore.AWSParameterStoreConfiguration;
import io.micronaut.discovery.aws.route53.Route53ClientDiscoveryConfiguration;
import io.micronaut.discovery.client.ClientUtil;
import io.micronaut.discovery.config.ConfigurationClient;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(classes={AWSSimpleSystemsManagementAsyncClient.class, AWSClientConfiguration.class}), @Requires(env={"ec2"}), @Requires(beans={AWSParameterStoreConfiguration.class})})
public class AWSParameterStoreConfigClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AWSParameterStoreConfiguration.class);
    private final int PRIORITY_TOP = 150;
    private final int PRIORITY_DOWN = 100;
    private final int PRIORITY_INCREMENT = 10;
    private final AWSClientConfiguration awsConfiguration;
    private final AWSParameterStoreConfiguration awsParameterStoreConfiguration;
    private final Route53ClientDiscoveryConfiguration route53ClientDiscoveryConfiguration;
    private AWSSimpleSystemsManagementAsync client;
    private ExecutorService executionService;

    AWSParameterStoreConfigClient(AWSClientConfiguration awsConfiguration, AWSParameterStoreConfiguration awsParameterStoreConfiguration, Route53ClientDiscoveryConfiguration route53ClientDiscoveryConfiguration) {
        this.awsConfiguration = awsConfiguration;
        this.awsParameterStoreConfiguration = awsParameterStoreConfiguration;
        try {
            this.client = (AWSSimpleSystemsManagementAsync)((AWSSimpleSystemsManagementAsyncClientBuilder)AWSSimpleSystemsManagementAsyncClient.asyncBuilder().withClientConfiguration(awsConfiguration.getClientConfiguration())).build();
        }
        catch (SdkClientException sce) {
            LOG.warn("Error creating Simple Systems Management client - check your credentials: " + sce.getMessage(), (Throwable)sce);
        }
        this.route53ClientDiscoveryConfiguration = route53ClientDiscoveryConfiguration;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.awsParameterStoreConfiguration.isEnabled()) {
            return Flowable.empty();
        }
        Set activeNames = environment.getActiveNames();
        Optional<String> serviceId = this.route53ClientDiscoveryConfiguration.getServiceId();
        String path = this.awsParameterStoreConfiguration.getRootHierarchyPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String pathPrefix = path.substring(1);
        String commonConfigPath = path + "application";
        String commonPrefix = commonConfigPath.substring(1);
        boolean hasApplicationSpecificConfig = serviceId.isPresent();
        String applicationSpecificPath = hasApplicationSpecificConfig ? path + serviceId.get() : null;
        String applicationPrefix = hasApplicationSpecificConfig ? applicationSpecificPath.substring(1) : null;
        Flowable configurationValues = Flowable.fromPublisher(this.getParameters(commonConfigPath));
        if (hasApplicationSpecificConfig) {
            configurationValues = Flowable.concat((Publisher)configurationValues, (Publisher)Flowable.fromPublisher(this.getParameters(applicationSpecificPath)));
        }
        if (activeNames != null && activeNames.size() > 0) {
            for (String activeName : activeNames) {
                String environmentSpecificPath = commonConfigPath + "_" + activeName;
                configurationValues = Flowable.concat((Publisher)configurationValues, (Publisher)Flowable.fromPublisher(this.getParameters(environmentSpecificPath)));
            }
        }
        Flowable propertySourceFlowable = configurationValues.flatMap(keyValues -> Flowable.create(emitter -> {
            if (CollectionUtils.isEmpty((Collection)keyValues.getParameters())) {
                emitter.onComplete();
            } else {
                HashMap<String, Map> propertySources = new HashMap<String, Map>();
                for (Parameter parameter : keyValues.getParameters()) {
                    String fullName;
                    boolean validKey;
                    String key = parameter.getName();
                    String value = parameter.getValue();
                    boolean isFolder = key.endsWith("/") && value == null;
                    boolean isCommonConfigKey = key.substring(1).startsWith(commonPrefix);
                    boolean isApplicationSpecificConfigKey = hasApplicationSpecificConfig && key.startsWith(applicationPrefix);
                    boolean bl = validKey = isCommonConfigKey || isApplicationSpecificConfigKey;
                    if (isFolder || !validKey || (fullName = key.substring(pathPrefix.length() + 1)).contains("/")) continue;
                    Set<String> propertySourceNames = this.calcPropertySourceNames(fullName, activeNames);
                    String lookupKey = key;
                    if (!lookupKey.startsWith("/")) {
                        lookupKey = "/" + lookupKey;
                    }
                    Flowable properties = Flowable.fromPublisher(this.convertParameterHierarchyToMap((GetParametersResult)keyValues));
                    Flowable hierarchy = Flowable.fromPublisher(this.getHierarchy(lookupKey));
                    Flowable propertiesHierarchy = Flowable.fromPublisher(this.convertParameterHierarchyToMap((GetParametersByPathResult)hierarchy.blockingFirst()));
                    properties = Flowable.concat((Publisher)properties, (Publisher)propertiesHierarchy);
                    for (String propertySourceName : propertySourceNames) {
                        Map values = propertySources.computeIfAbsent(propertySourceName, s -> new LinkedHashMap());
                        for (Map propMap : (List)properties.toList().blockingGet()) {
                            values.putAll(propMap);
                        }
                    }
                }
                for (Map.Entry entry : propertySources.entrySet()) {
                    String name = (String)entry.getKey();
                    int priority = -200 + (name.endsWith("]") ? 150 : 100);
                    if (hasApplicationSpecificConfig && name.startsWith((String)serviceId.get())) {
                        priority += 10;
                    }
                    emitter.onNext((Object)PropertySource.of((String)("route53-" + name), (Map)((Map)entry.getValue()), (int)priority));
                }
                emitter.onComplete();
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR));
        propertySourceFlowable = propertySourceFlowable.onErrorResumeNext(throwable -> {
            if (throwable instanceof ConfigurationException) {
                return Flowable.error((Throwable)throwable);
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
        });
        if (this.executionService != null) {
            return propertySourceFlowable.subscribeOn(Schedulers.from((Executor)this.executionService));
        }
        return propertySourceFlowable;
    }

    public String getDescription() {
        return "AWS Parameter Store";
    }

    private Publisher<GetParametersByPathResult> getHierarchy(String path) {
        GetParametersByPathRequest getRequest = new GetParametersByPathRequest().withWithDecryption(Boolean.valueOf(this.awsParameterStoreConfiguration.getUseSecureParameters())).withPath(path).withRecursive(Boolean.valueOf(true));
        Future future = this.client.getParametersByPathAsync(getRequest);
        Flowable invokeFlowable = Flowable.fromFuture((Future)future, (Scheduler)Schedulers.io());
        invokeFlowable = invokeFlowable.onErrorResumeNext(throwable -> {
            if (throwable instanceof SdkClientException) {
                return Flowable.error((Throwable)throwable);
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
        });
        return invokeFlowable;
    }

    private Publisher<GetParametersResult> getParameters(String path) {
        GetParametersRequest getRequest = new GetParametersRequest().withWithDecryption(Boolean.valueOf(this.awsParameterStoreConfiguration.getUseSecureParameters())).withNames(new String[]{path});
        Future future = this.client.getParametersAsync(getRequest);
        Flowable invokeFlowable = Flowable.fromFuture((Future)future, (Scheduler)Schedulers.io());
        invokeFlowable = invokeFlowable.onErrorResumeNext(throwable -> {
            if (throwable instanceof SdkClientException) {
                return Flowable.error((Throwable)throwable);
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from AWS Parameter Store: " + throwable.getMessage(), throwable));
        });
        return invokeFlowable;
    }

    @Inject
    void setExecutionService(@Named(value="io") @Nullable ExecutorService executionService) {
        if (executionService != null) {
            this.executionService = executionService;
        }
    }

    private Set<String> calcPropertySourceNames(String prefix, Set<String> activeNames) {
        return ClientUtil.calcPropertySourceNames(prefix, activeNames);
    }

    private Publisher<Map<String, Object>> convertParameterHierarchyToMap(GetParametersByPathResult result) {
        return this.convertParametersToMap(result.getParameters());
    }

    private Publisher<Map<String, Object>> convertParameterHierarchyToMap(GetParametersResult result) {
        return this.convertParametersToMap(result.getParameters());
    }

    private Publisher<Map<String, Object>> convertParametersToMap(List<Parameter> params) {
        HashMap<String, String> output = new HashMap<String, String>();
        block9: for (Parameter param : params) {
            switch (param.getType()) {
                case "StringList": {
                    String[] items;
                    for (String item : items = param.getValue().split(",")) {
                        String[] keyValue = item.split("=");
                        output.put(keyValue[0], keyValue[1]);
                    }
                    continue block9;
                }
                case "SecureString": {
                    String[] keyValue = param.getValue().split("=");
                    output.put(keyValue[0], keyValue[1]);
                    break;
                }
                default: {
                    String[] keyVal = param.getValue().split("=");
                    output.put(keyVal[0], keyVal[1]);
                }
            }
        }
        return Publishers.just(output);
    }
}

