/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.route53;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsync;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsyncClientBuilder;
import io.micronaut.configuration.aws.AWSClientConfiguration;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.aws.route53.AWSServiceDiscoveryResolver;
import javax.inject.Singleton;

@Requirements(value={@Requires(classes={AWSServiceDiscoveryAsync.class}), @Requires(env={"ec2"})})
@Singleton
public class AWSServiceDiscoveryClientResolver
implements AWSServiceDiscoveryResolver {
    private final AWSServiceDiscoveryAsync awsServiceDiscoveryAsync;

    public AWSServiceDiscoveryClientResolver(AWSClientConfiguration clientConfiguration) {
        this.awsServiceDiscoveryAsync = clientConfiguration != null ? (AWSServiceDiscoveryAsync)((AWSServiceDiscoveryAsyncClientBuilder)AWSServiceDiscoveryAsyncClientBuilder.standard().withClientConfiguration(clientConfiguration.getClientConfiguration())).build() : (AWSServiceDiscoveryAsync)((AWSServiceDiscoveryAsyncClientBuilder)AWSServiceDiscoveryAsyncClientBuilder.standard().withRegion(Regions.DEFAULT_REGION)).build();
    }

    @Override
    public AWSServiceDiscoveryAsync resolve(Environment environment) {
        return this.awsServiceDiscoveryAsync;
    }
}

