/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.route53.client;

import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsync;
import com.amazonaws.services.servicediscovery.model.InstanceSummary;
import com.amazonaws.services.servicediscovery.model.ListInstancesRequest;
import com.amazonaws.services.servicediscovery.model.ListInstancesResult;
import com.amazonaws.services.servicediscovery.model.ListServicesRequest;
import com.amazonaws.services.servicediscovery.model.ListServicesResult;
import com.amazonaws.services.servicediscovery.model.ServiceFilter;
import com.amazonaws.services.servicediscovery.model.ServiceSummary;
import io.micronaut.configuration.aws.AWSClientConfiguration;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.route53.AWSServiceDiscoveryResolver;
import io.micronaut.discovery.aws.route53.Route53ClientDiscoveryConfiguration;
import io.micronaut.discovery.aws.route53.Route53DiscoveryConfiguration;
import io.micronaut.discovery.aws.route53.registration.EC2ServiceInstance;
import io.micronaut.http.client.annotation.Client;
import io.reactivex.Flowable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Client(id="route53", path="/", configuration=Route53ClientDiscoveryConfiguration.class)
@Requirements(value={@Requires(classes={AWSServiceDiscoveryAsync.class, AWSClientConfiguration.class}), @Requires(env={"ec2"}), @Requires(beans={Route53DiscoveryConfiguration.class}), @Requires(beans={AWSClientConfiguration.class}), @Requires(property="aws.route53.discovery.enabled", value="true", defaultValue="false")})
public class Route53AutoNamingClient
implements DiscoveryClient {
    public static final String ENABLED = "aws.route53.discovery.enabled";
    private final AWSClientConfiguration awsClientConfiguration;
    private final AWSServiceDiscoveryResolver awsServiceDiscoveryResolver;
    private final Environment environment;
    private Route53ClientDiscoveryConfiguration route53ClientDiscoveryConfiguration;

    public Route53AutoNamingClient(AWSClientConfiguration awsClientConfiguration, Route53ClientDiscoveryConfiguration route53ClientDiscoveryConfiguration, AWSServiceDiscoveryResolver awsServiceDiscoveryResolver, Environment environment) {
        this.awsClientConfiguration = awsClientConfiguration;
        this.route53ClientDiscoveryConfiguration = route53ClientDiscoveryConfiguration;
        this.awsServiceDiscoveryResolver = awsServiceDiscoveryResolver;
        this.environment = environment;
    }

    public Route53ClientDiscoveryConfiguration getRoute53ClientDiscoveryConfiguration() {
        return this.route53ClientDiscoveryConfiguration;
    }

    public void setRoute53ClientDiscoveryConfiguration(Route53ClientDiscoveryConfiguration route53ClientDiscoveryConfiguration) {
        this.route53ClientDiscoveryConfiguration = route53ClientDiscoveryConfiguration;
    }

    public String getDescription() {
        return "Route 53 Auto Naming Client";
    }

    private Flowable<List<ServiceInstance>> convertInstancesResulttoServiceInstances(ListInstancesResult instancesResult) {
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (InstanceSummary instanceSummary : instancesResult.getInstances()) {
            try {
                String uri = "http://" + (String)instanceSummary.getAttributes().get("URI");
                ServiceInstance serviceInstance = new EC2ServiceInstance(instanceSummary.getId(), new URI(uri)).metadata(instanceSummary.getAttributes()).build();
                serviceInstances.add(serviceInstance);
            }
            catch (URISyntaxException e) {
                return Flowable.error((Throwable)e);
            }
        }
        return Flowable.just(serviceInstances);
    }

    public Publisher<List<ServiceInstance>> getInstances(String serviceId) {
        if (serviceId == null) {
            serviceId = this.getRoute53ClientDiscoveryConfiguration().getAwsServiceId();
        }
        ListInstancesRequest instancesRequest = new ListInstancesRequest().withServiceId(serviceId);
        Future instanceResult = this.getDiscoveryClient().listInstancesAsync(instancesRequest);
        Flowable observableInstanceResult = Flowable.fromFuture((Future)instanceResult);
        return observableInstanceResult.flatMap(this::convertInstancesResulttoServiceInstances);
    }

    public Publisher<List<String>> getServiceIds() {
        ServiceFilter serviceFilter = new ServiceFilter().withName("NAMESPACE_ID").withValues(new String[]{this.getRoute53ClientDiscoveryConfiguration().getNamespaceId()});
        ListServicesRequest listServicesRequest = new ListServicesRequest().withFilters(new ServiceFilter[]{serviceFilter});
        Future response = this.getDiscoveryClient().listServicesAsync(listServicesRequest);
        Flowable flowableList = Flowable.fromFuture((Future)response);
        return flowableList.flatMap(this::convertServiceIds);
    }

    public void close() {
        this.getDiscoveryClient().shutdown();
    }

    private Publisher<List<String>> convertServiceIds(ListServicesResult listServicesResult) {
        List services = listServicesResult.getServices();
        ArrayList<String> serviceIds = new ArrayList<String>();
        for (ServiceSummary service : services) {
            serviceIds.add(service.getId());
        }
        return Publishers.just(serviceIds);
    }

    private AWSServiceDiscoveryAsync getDiscoveryClient() {
        return this.awsServiceDiscoveryResolver.resolve(this.environment);
    }
}

