/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.route53.registration;

import com.amazonaws.services.servicediscovery.AWSServiceDiscovery;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsync;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryClient;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryClientBuilder;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreateServiceRequest;
import com.amazonaws.services.servicediscovery.model.CreateServiceResult;
import com.amazonaws.services.servicediscovery.model.CustomHealthStatus;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteServiceRequest;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.DnsConfig;
import com.amazonaws.services.servicediscovery.model.DnsRecord;
import com.amazonaws.services.servicediscovery.model.GetOperationRequest;
import com.amazonaws.services.servicediscovery.model.GetOperationResult;
import com.amazonaws.services.servicediscovery.model.RecordType;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.RoutingPolicy;
import com.amazonaws.services.servicediscovery.model.Service;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import io.micronaut.configuration.aws.AWSClientConfiguration;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.route53.AWSServiceDiscoveryResolver;
import io.micronaut.discovery.aws.route53.Route53AutoRegistrationConfiguration;
import io.micronaut.discovery.aws.route53.registration.ServiceRegistrationStatusTask;
import io.micronaut.discovery.client.registration.DiscoveryServiceAutoRegistration;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.aws.AmazonComputeInstanceMetadataResolver;
import io.micronaut.health.HealthStatus;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import io.reactivex.Flowable;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(classes={AWSServiceDiscovery.class}), @Requires(env={"ec2"}), @Requires(beans={Route53AutoRegistrationConfiguration.class}), @Requires(property="aws.route53.registration.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.application.name")})
public class Route53AutoNamingRegistrationClient
extends DiscoveryServiceAutoRegistration {
    public static final String AWS_INSTANCE_PORT = "AWS_INSTANCE_PORT";
    public static final String AWS_INSTANCE_IPV4 = "AWS_INSTANCE_IPV4";
    public static final String AWS_INSTANCE_CNAME = "AWS_INSTANCE_CNAME";
    public static final String AWS_INSTANCE_IPV6 = "AWS_INSTANCE_IPV6";
    public static final String AWS_ALIAS_DNS_NAME = "AWS_ALIAS_DNS_NAME";
    public static final String ENABLED = "aws.route53.registration.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(Route53AutoNamingRegistrationClient.class);
    private final Route53AutoRegistrationConfiguration route53AutoRegistrationConfiguration;
    private final Environment environment;
    private final AWSClientConfiguration clientConfiguration;
    private AmazonComputeInstanceMetadataResolver amazonComputeInstanceMetadataResolver;
    private Service discoveryService;
    private Executor executorService;
    private AWSServiceDiscoveryResolver awsServiceDiscoveryResolver;

    protected Route53AutoNamingRegistrationClient(Environment environment, Route53AutoRegistrationConfiguration route53AutoRegistrationConfiguration, AWSClientConfiguration clientConfiguration, AmazonComputeInstanceMetadataResolver amazonComputeInstanceMetadataResolver, @Named(value="io") Executor executorService, AWSServiceDiscoveryResolver awsServiceDiscoveryResolver) {
        super(route53AutoRegistrationConfiguration);
        this.environment = environment;
        this.route53AutoRegistrationConfiguration = route53AutoRegistrationConfiguration;
        this.clientConfiguration = clientConfiguration;
        this.awsServiceDiscoveryResolver = awsServiceDiscoveryResolver;
        this.amazonComputeInstanceMetadataResolver = amazonComputeInstanceMetadataResolver;
        this.executorService = executorService;
    }

    protected void pulsate(ServiceInstance instance, HealthStatus status) {
        Optional opt = instance.getInstanceId();
        if (!opt.isPresent()) {
            if (instance.getMetadata().contains("instanceId")) {
                opt = Optional.of(instance.getMetadata().asMap().get("instanceId"));
            } else if (LOG.isErrorEnabled()) {
                LOG.error("Cannot determine the instance ID. Are you sure you are running on AWS EC2?");
            }
        }
        opt.ifPresent(instanceId -> {
            if (this.discoveryService != null && this.discoveryService.getHealthCheckCustomConfig() != null) {
                CustomHealthStatus customHealthStatus = CustomHealthStatus.UNHEALTHY;
                if (status.getOperational().isPresent()) {
                    customHealthStatus = CustomHealthStatus.HEALTHY;
                }
                UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest = new UpdateInstanceCustomHealthStatusRequest().withInstanceId(instanceId).withServiceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).withStatus(customHealthStatus);
                this.getDiscoveryClient().updateInstanceCustomHealthStatus(updateInstanceCustomHealthStatusRequest);
            }
            if (status.getOperational().isPresent() && !((Boolean)status.getOperational().get()).booleanValue()) {
                this.getDiscoveryClient().deregisterInstance(new DeregisterInstanceRequest().withInstanceId(instanceId).withServiceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()));
                LOG.info("Health status is non operational, instance id " + instanceId + " was de-registered from the discovery service.");
            }
        });
    }

    protected void deregister(ServiceInstance instance) {
        if (instance.getInstanceId().isPresent()) {
            DeregisterInstanceRequest deregisterInstanceRequest = new DeregisterInstanceRequest().withServiceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).withInstanceId((String)instance.getInstanceId().get());
            this.getDiscoveryClient().deregisterInstance(deregisterInstanceRequest);
        }
    }

    protected void register(final ServiceInstance instance) {
        Optional instanceMetadata;
        HashMap<String, String> instanceAttributes = new HashMap<String, String>();
        if (instance.getPort() > 0) {
            instanceAttributes.put(AWS_INSTANCE_PORT, Integer.toString(instance.getPort()));
        }
        if (this.amazonComputeInstanceMetadataResolver != null && (instanceMetadata = this.amazonComputeInstanceMetadataResolver.resolve(this.environment)).isPresent()) {
            ComputeInstanceMetadata computeInstanceMetadata = (ComputeInstanceMetadata)instanceMetadata.get();
            if (computeInstanceMetadata.getPublicIpV4() != null) {
                instanceAttributes.put(AWS_INSTANCE_IPV4, computeInstanceMetadata.getPublicIpV4());
            } else if (computeInstanceMetadata.getPrivateIpV4() != null) {
                instanceAttributes.put(AWS_INSTANCE_IPV4, computeInstanceMetadata.getPrivateIpV4());
            }
            if (!instanceAttributes.containsKey(AWS_INSTANCE_IPV4)) {
                if (computeInstanceMetadata.getPublicIpV4() != null) {
                    instanceAttributes.put(AWS_INSTANCE_IPV6, computeInstanceMetadata.getPublicIpV6());
                } else if (computeInstanceMetadata.getPrivateIpV6() != null) {
                    instanceAttributes.put(AWS_INSTANCE_IPV6, computeInstanceMetadata.getPrivateIpV6());
                }
            }
        }
        ConvertibleValues metadata = instance.getMetadata();
        String instanceId = null;
        if (instance.getInstanceId().isPresent()) {
            instanceId = (String)instance.getInstanceId().get();
        } else if (metadata.contains("instanceId")) {
            instanceId = (String)metadata.asMap().get("instanceId");
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Cannot determine the instance ID. Are you sure you are running on AWS EC2?");
        }
        RegisterInstanceRequest instanceRequest = new RegisterInstanceRequest().withServiceId(this.route53AutoRegistrationConfiguration.getAwsServiceId()).withInstanceId(instanceId).withCreatorRequestId(Long.toString(System.nanoTime())).withAttributes(instanceAttributes);
        Future instanceResult = this.getDiscoveryClient().registerInstanceAsync(instanceRequest);
        Flowable flowableResult = Flowable.fromFuture((Future)instanceResult);
        flowableResult.subscribe((Subscriber)new Subscriber<RegisterInstanceResult>(){

            public void onNext(RegisterInstanceResult registerInstanceResult) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Called AWS to register service [{}] with {}", (Object)instance.getId(), (Object)Route53AutoNamingRegistrationClient.this.route53AutoRegistrationConfiguration.getAwsServiceId());
                }
                if (registerInstanceResult.getOperationId() != null) {
                    ServiceRegistrationStatusTask serviceRegistrationStatusTask = new ServiceRegistrationStatusTask(Route53AutoNamingRegistrationClient.this.getDiscoveryClient(), Route53AutoNamingRegistrationClient.this.route53AutoRegistrationConfiguration, instance, registerInstanceResult.getOperationId());
                    Route53AutoNamingRegistrationClient.this.executorService.execute(serviceRegistrationStatusTask);
                }
            }

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onError(Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error registering instance with AWS:" + t.getMessage(), t);
                }
                if (Route53AutoNamingRegistrationClient.this.route53AutoRegistrationConfiguration.isFailFast() && instance instanceof EmbeddedServerInstance) {
                    LOG.error("Error registering instance with AWS and Failfast is set: stopping instance");
                    ((EmbeddedServerInstance)instance).getEmbeddedServer().stop();
                }
            }

            public void onComplete() {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Success calling register service request [{}] with {} is complete.", (Object)instance.getId(), (Object)Route53AutoNamingRegistrationClient.this.route53AutoRegistrationConfiguration.getAwsServiceId());
                }
            }
        });
    }

    public void deleteService(String serviceId) {
        DeleteServiceRequest deleteServiceRequest = new DeleteServiceRequest().withId(serviceId);
        this.getDiscoveryClient().deleteService(deleteServiceRequest);
    }

    public void deleteNamespace(String namespaceId) {
        DeleteNamespaceRequest deleteNamespaceRequest = new DeleteNamespaceRequest().withId(namespaceId);
        this.getDiscoveryClient().deleteNamespace(deleteNamespaceRequest);
    }

    public String createNamespace(String name) {
        String requestId = Long.toString(System.nanoTime());
        CreatePublicDnsNamespaceRequest publicDnsNamespaceRequest = new CreatePublicDnsNamespaceRequest().withCreatorRequestId(requestId).withName(name).withDescription("test");
        CreatePublicDnsNamespaceResult clientResult = this.getDiscoveryClient().createPublicDnsNamespace(publicDnsNamespaceRequest);
        String operationId = clientResult.getOperationId();
        GetOperationResult opResult = this.checkOperation(operationId);
        return (String)opResult.getOperation().getTargets().get("NAMESPACE");
    }

    public String createService(AWSServiceDiscovery serviceDiscovery, String name, String description, String namespaceId, Long ttl) {
        if (serviceDiscovery == null) {
            serviceDiscovery = (AWSServiceDiscovery)((AWSServiceDiscoveryClientBuilder)AWSServiceDiscoveryClient.builder().withClientConfiguration(this.clientConfiguration.getClientConfiguration())).build();
        }
        DnsRecord dnsRecord = new DnsRecord().withType(RecordType.A).withTTL(ttl);
        DnsConfig dnsConfig = new DnsConfig().withDnsRecords(new DnsRecord[]{dnsRecord}).withNamespaceId(namespaceId).withRoutingPolicy(RoutingPolicy.WEIGHTED);
        CreateServiceRequest createServiceRequest = new CreateServiceRequest().withDnsConfig(dnsConfig).withDescription(description).withName(name);
        CreateServiceResult servicerResult = serviceDiscovery.createService(createServiceRequest);
        Service createdService = servicerResult.getService();
        return createdService.getId();
    }

    private GetOperationResult checkOperation(String operationId) {
        String result = "";
        GetOperationResult opResult = null;
        try {
            while (!result.equals("SUCCESS") && !result.equals("FAIL")) {
                opResult = this.getDiscoveryClient().getOperation(new GetOperationRequest().withOperationId(operationId));
                result = opResult.getOperation().getStatus();
                if (opResult.getOperation().getStatus().equals("SUCCESS")) {
                    LOG.info("Successfully get operation id " + operationId);
                    return opResult;
                }
                if (opResult.getOperation().getStatus().equals("FAIL")) {
                    LOG.error("Error calling aws service for operationId:" + operationId + " error code:" + opResult.getOperation().getErrorCode() + " error message:" + opResult.getOperation().getErrorMessage());
                    return opResult;
                }
                Thread.currentThread();
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error polling for aws response operation:", (Throwable)e);
        }
        return opResult;
    }

    public AWSServiceDiscoveryAsync getDiscoveryClient() {
        return this.awsServiceDiscoveryResolver.resolve(this.environment);
    }

    public Service getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(Service discoveryService) {
        this.discoveryService = discoveryService;
    }
}

