/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.aws.route53.registration;

import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryAsync;
import com.amazonaws.services.servicediscovery.model.GetOperationRequest;
import com.amazonaws.services.servicediscovery.model.GetOperationResult;
import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.aws.route53.Route53AutoRegistrationConfiguration;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class ServiceRegistrationStatusTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistrationStatusTask.class);
    private final String operationId;
    private final Route53AutoRegistrationConfiguration route53AutoRegistrationConfiguration;
    private final ServiceInstance embeddedServerInstance;
    private final AWSServiceDiscoveryAsync discoveryClient;
    private boolean registered = false;

    ServiceRegistrationStatusTask(AWSServiceDiscoveryAsync discoveryClient, Route53AutoRegistrationConfiguration route53AutoRegistrationConfiguration, ServiceInstance embeddedServerInstance, String operationId) {
        this.discoveryClient = discoveryClient;
        this.route53AutoRegistrationConfiguration = route53AutoRegistrationConfiguration;
        this.embeddedServerInstance = embeddedServerInstance;
        this.operationId = operationId;
    }

    @Override
    public void run() {
        block5: {
            while (!this.registered) {
                GetOperationRequest operationRequest = new GetOperationRequest().withOperationId(this.operationId);
                GetOperationResult result = this.discoveryClient.getOperation(operationRequest);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Service registration for operation " + this.operationId + " resulted in " + result.getOperation().getStatus());
                }
                if (!result.getOperation().getStatus().equalsIgnoreCase("failure") && !result.getOperation().getStatus().equalsIgnoreCase("success")) continue;
                this.registered = true;
                if (!result.getOperation().getStatus().equalsIgnoreCase("failure") || !this.route53AutoRegistrationConfiguration.isFailFast() || !(this.embeddedServerInstance instanceof EmbeddedServerInstance)) continue;
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error registering instance shutting down instance because failfast is set.");
                }
                ((EmbeddedServerInstance)this.embeddedServerInstance).getEmbeddedServer().stop();
            }
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error("Registration monitor service has been aborted, unable to verify proper service registration on Route 53.", (Throwable)e);
            }
        }
    }
}

