/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client;

import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public abstract class DiscoveryServerInstanceList
implements ServiceInstanceList {
    private final DiscoveryClientConfiguration configuration;

    public DiscoveryServerInstanceList(DiscoveryClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<ServiceInstance> getInstances() {
        List<ServiceInstance> allZones = this.configuration.getAllZones();
        if (!allZones.isEmpty()) {
            return allZones;
        }
        String spec = (this.configuration.isSecure() ? "https" : "http") + "://" + this.configuration.getHost() + ":" + this.configuration.getPort();
        return Collections.singletonList(ServiceInstance.builder((String)this.getID(), (URI)URI.create(spec)).build());
    }
}

