/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client.registration;

import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.registration.AutoRegistration;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import io.reactivex.Flowable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class DiscoveryServiceAutoRegistration
extends AutoRegistration {
    protected DiscoveryServiceAutoRegistration(RegistrationConfiguration registrationConfiguration) {
        super(registrationConfiguration);
    }

    protected void performRegistration(final String discoveryService, final RegistrationConfiguration registration, final ServiceInstance instance, Publisher<HttpStatus> registrationObservable) {
        registrationObservable.subscribe((Subscriber)new Subscriber<HttpStatus>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(HttpStatus httpStatus) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registered service [{}] with {}", (Object)instance.getId(), (Object)discoveryService);
                }
            }

            public void onError(Throwable t) {
                if (LOG.isErrorEnabled()) {
                    String message = DiscoveryServiceAutoRegistration.this.getErrorMessage(discoveryService, t);
                    LOG.error(message, t);
                }
                if (registration.isFailFast() && instance instanceof EmbeddedServerInstance) {
                    ((EmbeddedServerInstance)instance).getEmbeddedServer().stop();
                }
            }

            public void onComplete() {
            }
        });
    }

    protected String getErrorMessage(Throwable e, String description) {
        HttpClientResponseException hcre;
        String message = e instanceof HttpClientResponseException ? ((hcre = (HttpClientResponseException)e).getStatus() == HttpStatus.BAD_REQUEST ? description + hcre.getResponse().getBody(String.class).orElse(e.getMessage()) : description + e.getMessage()) : description + e.getMessage();
        return message;
    }

    protected void performDeregistration(final String discoveryService, RegistrationConfiguration registration, Publisher<HttpStatus> deregisterPublisher, final String applicationName) {
        block5: {
            if (registration.isFailFast()) {
                try {
                    Flowable.fromPublisher(deregisterPublisher).blockingFirst();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("De-registered service [{}] with {}", (Object)applicationName, (Object)discoveryService);
                    }
                    break block5;
                }
                catch (Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error occurred de-registering service [" + applicationName + "] with " + discoveryService + ": " + t.getMessage(), t);
                    }
                    break block5;
                }
            }
            deregisterPublisher.subscribe((Subscriber)new Subscriber<HttpStatus>(){

                public void onSubscribe(Subscription subscription) {
                    subscription.request(1L);
                }

                public void onNext(HttpStatus httpStatus) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("De-registered service [{}] with {}", (Object)applicationName, (Object)discoveryService);
                    }
                }

                public void onError(Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error occurred de-registering service [" + applicationName + "] with " + discoveryService + ": " + t.getMessage(), t);
                    }
                }

                public void onComplete() {
                }
            });
        }
    }

    private String getErrorMessage(String discoveryService, Throwable e) {
        String description = "Error occurred during service registration with " + discoveryService + ": ";
        return this.getErrorMessage(e, description);
    }
}

