/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.http.client.exceptions.HttpClientException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public abstract class AbstractServiceEntry {
    protected final String name;
    private InetAddress address;
    private Integer port;
    private List<String> tags;
    private String ID;

    public AbstractServiceEntry(String name) {
        this.name = name;
    }

    @JsonProperty(value="ID")
    public Optional<String> getID() {
        return Optional.ofNullable(this.ID);
    }

    @JsonProperty(value="ID")
    public void setID(String id) {
        this.ID = id;
    }

    public Optional<InetAddress> getAddress() {
        return Optional.ofNullable(this.address);
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public OptionalInt getPort() {
        if (this.port != null) {
            return OptionalInt.of(this.port);
        }
        return OptionalInt.empty();
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public AbstractServiceEntry id(String id) {
        this.ID = id;
        return this;
    }

    public AbstractServiceEntry address(InetAddress address) {
        this.address = address;
        return this;
    }

    public AbstractServiceEntry address(String address) {
        try {
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new HttpClientException(e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public AbstractServiceEntry port(Integer port) {
        this.port = port;
        return this;
    }

    public AbstractServiceEntry tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractServiceEntry that = (AbstractServiceEntry)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.address, that.address) && Objects.equals(this.port, that.port) && Objects.equals(this.tags, that.tags) && Objects.equals(this.ID, that.ID);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.port, this.tags, this.ID);
    }
}

