/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.Toggleable;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Filter(patterns={"/v1/**"}, serviceId={"consul"})
@Requires(beans={ConsulConfiguration.class})
public class ConsulAslTokenFilter
implements HttpClientFilter,
Toggleable {
    public static final String HEADER_CONSUL_TOKEN = "X-Consul-Token";
    private final ConsulConfiguration configuration;

    public ConsulAslTokenFilter(ConsulConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnabled() {
        return this.configuration.getAslToken().isPresent();
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Optional<String> aslToken = this.configuration.getAslToken();
        aslToken.ifPresent(token -> request.header((CharSequence)HEADER_CONSUL_TOKEN, (CharSequence)token));
        return chain.proceed(request);
    }
}

