/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.discovery.consul.client.v1.Check;
import io.micronaut.discovery.consul.client.v1.NewCheck;
import io.micronaut.http.HttpMethod;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class HTTPCheck
extends NewCheck {
    private Duration interval;
    private final URL url;
    private HttpMethod method;
    private boolean TLSSkipVerify = false;
    private ConvertibleMultiValues<String> headers = ConvertibleMultiValues.empty();

    @JsonCreator
    public HTTPCheck(@JsonProperty(value="Name") String name, @JsonProperty(value="HTTP") URL url) {
        super(name);
        this.url = url;
    }

    public HTTPCheck(@JsonProperty(value="HTTP") URL url) {
        this.url = url;
    }

    public Duration interval() {
        return this.interval;
    }

    protected void setInterval(String interval) {
        this.interval = (Duration)ConversionService.SHARED.convert((Object)interval, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid Duration Specified"));
    }

    public HTTPCheck interval(Duration interval) {
        if (interval != null) {
            this.interval = interval;
        }
        return this;
    }

    public HTTPCheck interval(String interval) {
        this.interval = (Duration)ConversionService.SHARED.convert((Object)interval, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid Duration Specified"));
        return this;
    }

    public Optional<String> getInterval() {
        if (this.interval != null) {
            return Optional.of(this.interval.getSeconds() + "s");
        }
        return Optional.empty();
    }

    @JsonProperty(value="HTTP")
    public URL getHTTP() {
        return this.url;
    }

    public Optional<HttpMethod> getMethod() {
        return Optional.ofNullable(this.method);
    }

    public ConvertibleMultiValues<String> getHeader() {
        return this.headers;
    }

    @JsonProperty(value="Header")
    public void setHeaders(Map<CharSequence, List<String>> headers) {
        this.headers = headers == null ? ConvertibleMultiValues.empty() : ConvertibleMultiValues.of(headers);
    }

    @JsonProperty(value="TLSSkipVerify")
    public boolean isTLSSkipVerify() {
        return this.TLSSkipVerify;
    }

    @JsonProperty(value="TLSSkipVerify")
    public void setTLSSkipVerify(boolean TLSSkipVerify) {
        this.TLSSkipVerify = TLSSkipVerify;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HTTPCheck headers(ConvertibleMultiValues<String> headers) {
        if (headers != null) {
            this.headers = headers;
        }
        return this;
    }

    public HTTPCheck tlsSkipVerify(boolean TLSSkipVerify) {
        this.TLSSkipVerify = TLSSkipVerify;
        return this;
    }

    public HTTPCheck method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public HTTPCheck id(String ID) {
        return (HTTPCheck)super.id(ID);
    }

    @Override
    public HTTPCheck status(Check.Status status) {
        return (HTTPCheck)super.status(status);
    }

    @Override
    public HTTPCheck notes(String notes) {
        return (HTTPCheck)super.notes(notes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPCheck httpCheck = (HTTPCheck)o;
        return this.TLSSkipVerify == httpCheck.TLSSkipVerify && Objects.equals(this.interval, httpCheck.interval) && Objects.equals(this.url, httpCheck.url) && this.method == httpCheck.method && Objects.equals(this.headers, httpCheck.headers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval, this.url, this.method, this.TLSSkipVerify, this.headers);
    }
}

