/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.consul.client.v1.AbstractServiceEntry;
import io.micronaut.discovery.consul.client.v1.HTTPCheck;
import io.micronaut.discovery.consul.client.v1.NewCheck;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class NewServiceEntry
extends AbstractServiceEntry {
    private List<NewCheck> checks = new ArrayList<NewCheck>(1);

    @JsonCreator
    public NewServiceEntry(@JsonProperty(value="Name") String serviceName) {
        super(serviceName);
    }

    public List<NewCheck> getChecks() {
        return this.checks;
    }

    public NewServiceEntry checks(List<NewCheck> checks) {
        if (checks != null) {
            this.checks.addAll(checks);
        }
        return this;
    }

    public NewServiceEntry check(NewCheck check) {
        if (check != null) {
            this.checks.add(check);
        }
        return this;
    }

    @Override
    public NewServiceEntry id(String id) {
        return (NewServiceEntry)super.id(id);
    }

    @Override
    public NewServiceEntry address(InetAddress address) {
        return (NewServiceEntry)super.address(address);
    }

    @Override
    public NewServiceEntry address(String address) {
        return (NewServiceEntry)super.address(address);
    }

    @Override
    public NewServiceEntry port(Integer port) {
        return (NewServiceEntry)super.port(port);
    }

    @Override
    public NewServiceEntry tags(List<String> tags) {
        return (NewServiceEntry)super.tags(tags);
    }

    public NewServiceEntry tags(String ... tags) {
        return (NewServiceEntry)super.tags(Arrays.asList(tags));
    }

    protected void setChecks(List<HTTPCheck> checks) {
        if (CollectionUtils.isNotEmpty(checks)) {
            this.checks.addAll(checks);
        }
    }
}

