/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.util.StringUtils;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class NodeEntry {
    private final String node;
    private final InetAddress address;
    private String datacenter;
    private Map<String, String> taggedAddresses;
    private Map<String, String> nodeMetadata;

    @JsonCreator
    public NodeEntry(@JsonProperty(value="Node") String nodeId, @JsonProperty(value="Address") InetAddress address) {
        this.node = nodeId;
        this.address = address;
    }

    public Map<String, String> getTaggedAddresses() {
        if (this.taggedAddresses == null) {
            return Collections.emptyMap();
        }
        return this.taggedAddresses;
    }

    public void setTaggedAddresses(Map<String, String> taggedAddresses) {
        this.taggedAddresses = taggedAddresses;
    }

    public Map<String, String> getNodeMetadata() {
        if (this.nodeMetadata == null) {
            return Collections.emptyMap();
        }
        return this.nodeMetadata;
    }

    public NodeEntry nodeMetadata(Map<String, String> nodeMetadata) {
        this.nodeMetadata = nodeMetadata;
        return this;
    }

    public void setNodeMetadata(Map<String, String> nodeMetadata) {
        this.nodeMetadata = nodeMetadata;
    }

    public String getNode() {
        return this.node;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public NodeEntry datacenter(String datacenter) {
        if (StringUtils.isNotEmpty((CharSequence)datacenter)) {
            this.datacenter = datacenter;
        }
        return this;
    }

    public NodeEntry taggedAddresses(Map<String, String> taggedAddresses) {
        this.taggedAddresses = taggedAddresses;
        return this;
    }
}

