/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.config;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import io.micronaut.discovery.consul.condition.RequiresConsul;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.jackson.env.JsonPropertySourceLoader;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@RequiresConsul
@Requirements(value={@Requires(beans={ConsulClient.class}), @Requires(property="micronaut.config-client.enabled", value="true", defaultValue="false")})
public class ConsulConfigurationClient
implements ConfigurationClient {
    private final ConsulClient consulClient;
    private final ConsulConfiguration consulConfiguration;
    private final Map<String, PropertySourceLoader> loaderByFormatMap = new ConcurrentHashMap<String, PropertySourceLoader>();
    private ExecutorService executionService;

    public ConsulConfigurationClient(ConsulClient consulClient, ConsulConfiguration consulConfiguration, Environment environment) {
        this.consulClient = consulClient;
        this.consulConfiguration = consulConfiguration;
        if (environment != null) {
            Collection loaders = environment.getPropertySourceLoaders();
            for (PropertySourceLoader loader : loaders) {
                Set extensions = loader.getExtensions();
                for (String extension : extensions) {
                    this.loaderByFormatMap.put(extension, loader);
                }
            }
        }
    }

    public String getDescription() {
        return this.consulClient.getDescription();
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.consulConfiguration.getConfiguration().isEnabled()) {
            return Flowable.empty();
        }
        Set activeNames = environment.getActiveNames();
        Optional<String> serviceId = this.consulConfiguration.getServiceId();
        ConsulConfiguration.ConsulConfigDiscoveryConfiguration configDiscoveryConfiguration = this.consulConfiguration.getConfiguration();
        ConfigDiscoveryConfiguration.Format format = configDiscoveryConfiguration.getFormat();
        String path = configDiscoveryConfiguration.getPath().orElse("config/");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String pathPrefix = path;
        String commonConfigPath = path + "application";
        boolean hasApplicationSpecificConfig = serviceId.isPresent();
        String applicationSpecificPath = hasApplicationSpecificConfig ? path + serviceId.get() : null;
        String dc = configDiscoveryConfiguration.getDatacenter().orElse(null);
        Function errorHandler = throwable -> {
            HttpClientResponseException httpClientResponseException;
            if (throwable instanceof HttpClientResponseException && (httpClientResponseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                return Flowable.empty();
            }
            return Flowable.error((Throwable)throwable);
        };
        Flowable configurationValues = Flowable.fromPublisher(this.consulClient.readValues(commonConfigPath, dc, null, null)).onErrorResumeNext(errorHandler);
        if (hasApplicationSpecificConfig) {
            configurationValues = Flowable.concat((Publisher)configurationValues, (Publisher)Flowable.fromPublisher(this.consulClient.readValues(applicationSpecificPath, dc, null, null)).onErrorResumeNext(errorHandler));
        }
        Flowable propertySourceFlowable = configurationValues.flatMap(keyValues -> Flowable.create(emitter -> {
            if (CollectionUtils.isEmpty((Collection)keyValues)) {
                emitter.onComplete();
            } else {
                HashMap<String, Map> propertySources = new HashMap<String, Map>();
                Base64.Decoder base64Decoder = Base64.getDecoder();
                block5: for (KeyValue keyValue : keyValues) {
                    boolean validKey;
                    String key = keyValue.getKey();
                    String value = keyValue.getValue();
                    boolean isFolder = key.endsWith("/") && value == null;
                    boolean isCommonConfigKey = key.startsWith(commonConfigPath);
                    boolean isApplicationSpecificConfigKey = hasApplicationSpecificConfig && key.startsWith(applicationSpecificPath);
                    boolean bl = validKey = isCommonConfigKey || isApplicationSpecificConfigKey;
                    if (isFolder || !validKey) continue;
                    switch (format) {
                        case FILE: {
                            String fileName = key.substring(pathPrefix.length());
                            int i = fileName.lastIndexOf(46);
                            if (i <= -1) break;
                            String ext = fileName.substring(i + 1);
                            fileName = fileName.substring(0, i);
                            PropertySourceLoader propertySourceLoader = this.resolveLoader(ext);
                            if (propertySourceLoader == null) continue block5;
                            Object propertySourceName = this.resolvePropertySourceName("application", fileName, activeNames);
                            if (hasApplicationSpecificConfig && propertySourceName == null) {
                                propertySourceName = this.resolvePropertySourceName((String)serviceId.get(), fileName, activeNames);
                            }
                            if (propertySourceName == null) continue block5;
                            byte[] decoded = base64Decoder.decode(value);
                            Map properties = propertySourceLoader.read((String)propertySourceName, decoded);
                            Map values = propertySources.computeIfAbsent((String)propertySourceName, s -> new LinkedHashMap());
                            values.putAll(properties);
                            break;
                        }
                        case NATIVE: {
                            byte[] decoded;
                            String property = null;
                            Set<String> propertySourceNames = null;
                            if (isCommonConfigKey) {
                                property = this.resolvePropertyName(commonConfigPath, key);
                                propertySourceNames = this.resolvePropertySourceNames(pathPrefix, key, activeNames);
                            } else if (isApplicationSpecificConfigKey) {
                                property = this.resolvePropertyName(applicationSpecificPath, key);
                                propertySourceNames = this.resolvePropertySourceNames(pathPrefix, key, activeNames);
                            }
                            if (property == null || propertySourceNames == null) break;
                            for (String propertySourceName : propertySourceNames) {
                                Map values = propertySources.computeIfAbsent(propertySourceName, s -> new LinkedHashMap());
                                decoded = base64Decoder.decode(value);
                                values.put(property, new String(decoded));
                            }
                            continue block5;
                        }
                        case JSON: 
                        case YAML: 
                        case PROPERTIES: {
                            String fullName = key.substring(pathPrefix.length());
                            if (fullName.contains("/")) break;
                            Set<String> propertySourceNames = this.calcPropertySourceNames(fullName, activeNames);
                            String formatName = format.name().toLowerCase(Locale.ENGLISH);
                            PropertySourceLoader propertySourceLoader = this.resolveLoader(formatName);
                            if (propertySourceLoader == null) {
                                emitter.onError((Throwable)new ConfigurationException("No PropertySourceLoader found for format [" + format + "]. Ensure ConfigurationClient is running within Micronaut container."));
                                return;
                            }
                            if (!propertySourceLoader.isEnabled()) continue block5;
                            byte[] decoded = base64Decoder.decode(value);
                            Map properties = propertySourceLoader.read(fullName, decoded);
                            for (String propertySourceName : propertySourceNames) {
                                Map values = propertySources.computeIfAbsent(propertySourceName, s -> new LinkedHashMap());
                                values.putAll(properties);
                            }
                            continue block5;
                        }
                    }
                }
                for (Map.Entry entry : propertySources.entrySet()) {
                    String name = (String)entry.getKey();
                    int priority = -200 + (name.endsWith("]") ? 150 : 100);
                    if (hasApplicationSpecificConfig && name.startsWith((String)serviceId.get())) {
                        priority += 10;
                    }
                    emitter.onNext((Object)PropertySource.of((String)("consul-" + name), (Map)((Map)entry.getValue()), (int)priority));
                }
                emitter.onComplete();
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR));
        propertySourceFlowable = propertySourceFlowable.onErrorResumeNext(throwable -> {
            if (throwable instanceof ConfigurationException) {
                return Flowable.error((Throwable)throwable);
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from Consul: " + throwable.getMessage(), throwable));
        });
        if (this.executionService != null) {
            return propertySourceFlowable.subscribeOn(Schedulers.from((Executor)this.executionService));
        }
        return propertySourceFlowable;
    }

    private String resolvePropertySourceName(String rootName, String fileName, Set<String> activeNames) {
        String propertySourceName = null;
        if (fileName.startsWith(rootName)) {
            String env;
            String envString = fileName.substring(rootName.length());
            if (StringUtils.isEmpty((CharSequence)envString)) {
                propertySourceName = rootName;
            } else if (envString.startsWith("-") && activeNames.contains(env = envString.substring(1))) {
                propertySourceName = rootName + '[' + env + ']';
            }
        }
        return propertySourceName;
    }

    private PropertySourceLoader resolveLoader(String formatName) {
        return this.loaderByFormatMap.computeIfAbsent(formatName, f -> this.defaultLoader(formatName));
    }

    private PropertySourceLoader defaultLoader(String format) {
        try {
            switch (format) {
                case "json": {
                    return new JsonPropertySourceLoader();
                }
                case "properties": {
                    return new PropertiesPropertySourceLoader();
                }
                case "yml": 
                case "yaml": {
                    return new YamlPropertySourceLoader();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConfigurationException("Unsupported properties file format: " + format);
    }

    @Inject
    void setExecutionService(@Named(value="io") @Nullable ExecutorService executionService) {
        if (executionService != null) {
            this.executionService = executionService;
        }
    }

    private Set<String> resolvePropertySourceNames(String finalPath, String key, Set<String> activeNames) {
        Set<String> propertySourceNames = null;
        String prefix = key.substring(finalPath.length());
        int i = prefix.indexOf(47);
        if (i > -1 && (propertySourceNames = this.calcPropertySourceNames(prefix = prefix.substring(0, i), activeNames)) == null) {
            return null;
        }
        return propertySourceNames;
    }

    private Set<String> calcPropertySourceNames(String prefix, Set<String> activeNames) {
        Set<String> propertySourceNames;
        if (prefix.indexOf(44) > -1) {
            String[] tokens = prefix.split(",");
            if (tokens.length == 1) {
                propertySourceNames = Collections.singleton(tokens[0]);
            } else {
                String name = tokens[0];
                HashSet<String> newSet = new HashSet<String>(tokens.length - 1);
                for (int j = 1; j < tokens.length; ++j) {
                    String envName = tokens[j];
                    if (!activeNames.contains(envName)) {
                        return Collections.emptySet();
                    }
                    newSet.add(name + '[' + envName + ']');
                }
                propertySourceNames = newSet;
            }
        } else {
            propertySourceNames = Collections.singleton(prefix);
        }
        return propertySourceNames;
    }

    private String resolvePropertyName(String commonConfigPath, String key) {
        String property = key.substring(commonConfigPath.length());
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            if (property.charAt(0) == '/') {
                property = property.substring(1);
            } else if (property.lastIndexOf(47) > -1) {
                property = property.substring(property.lastIndexOf(47) + 1);
            }
        }
        if (property.indexOf(47) == -1) {
            return property;
        }
        return null;
    }
}

