/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Flowable;
import java.util.Collections;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(beans={ConsulClient.class})})
public class ConsulHealthIndicator
implements HealthIndicator {
    private final ConsulClient client;

    public ConsulHealthIndicator(ConsulClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        Flowable statusFlowable = Flowable.fromPublisher(this.client.status());
        return statusFlowable.map(s -> {
            HealthResult.Builder builder = HealthResult.builder((String)"consul", (HealthStatus)HealthStatus.UP);
            builder.details(Collections.singletonMap("leader", s));
            return builder.build();
        }).onErrorReturn(throwable -> {
            HealthResult.Builder builder = HealthResult.builder((String)"consul", (HealthStatus)HealthStatus.DOWN);
            builder.exception(throwable);
            return builder.build();
        });
    }
}

