/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.discovery.DiscoveryConfiguration;
import io.micronaut.discovery.client.DiscoveryClientConfiguration;
import io.micronaut.discovery.eureka.client.v2.DataCenterInfo;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.discovery.eureka.client.v2.LeaseInfo;
import io.micronaut.discovery.eureka.condition.RequiresEureka;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ConfigurationProperties(value="eureka.client")
@RequiresEureka
public class EurekaConfiguration
extends DiscoveryClientConfiguration {
    public static final String PREFIX = "eureka.client";
    public static final String HOST = "eureka.client.host";
    public static final String PORT = "eureka.client.port";
    private static final int EUREKA_DEFAULT_PORT = 8761;
    private final HttpClientConfiguration.ConnectionPoolConfiguration eurekaConnectionPoolConfiguration;
    private EurekaDiscoveryConfiguration discovery = new EurekaDiscoveryConfiguration();
    private EurekaRegistrationConfiguration registration;

    public EurekaConfiguration(EurekaConnectionPoolConfiguration eurekaConnectionPoolConfiguration, ApplicationConfiguration applicationConfiguration, Optional<EurekaRegistrationConfiguration> eurekaRegistrationConfiguration) {
        super(applicationConfiguration);
        this.registration = eurekaRegistrationConfiguration.orElse(null);
        this.eurekaConnectionPoolConfiguration = eurekaConnectionPoolConfiguration;
        this.setPort(8761);
    }

    @Override
    @Nonnull
    public EurekaDiscoveryConfiguration getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(EurekaDiscoveryConfiguration discovery) {
        if (discovery != null) {
            this.discovery = discovery;
        }
    }

    @Override
    @Nullable
    public EurekaRegistrationConfiguration getRegistration() {
        return this.registration;
    }

    public boolean shouldLogAmazonMetadataErrors() {
        return true;
    }

    @Override
    protected String getServiceID() {
        return "eureka";
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.eurekaConnectionPoolConfiguration;
    }

    @ConfigurationProperties(value="registration")
    @Requires(property="micronaut.application.name")
    public static class EurekaRegistrationConfiguration
    extends RegistrationConfiguration {
        public static final String PREFIX = "eureka.client.registration";
        public static final String IP_ADDRESS = "eureka.client.registration.ip-addr";
        @ConfigurationBuilder
        InstanceInfo instanceInfo;
        @ConfigurationBuilder(configurationPrefix="lease-info")
        LeaseInfo.Builder leaseInfo = LeaseInfo.Builder.newBuilder();
        private final boolean explicitInstanceId;

        public EurekaRegistrationConfiguration(EmbeddedServer embeddedServer, ApplicationConfiguration applicationConfiguration, @Value(value="${eureka.client.registration.ip-addr}") @Nullable String ipAddress, @Nullable DataCenterInfo dataCenterInfo) {
            String instanceId = applicationConfiguration.getInstance().getId().orElse(null);
            String applicationName = applicationConfiguration.getName().orElse("application");
            boolean bl = this.explicitInstanceId = instanceId != null;
            this.instanceInfo = ipAddress != null ? new InstanceInfo(embeddedServer.getHost(), embeddedServer.getPort(), ipAddress, applicationName, this.explicitInstanceId ? instanceId : applicationName) : new InstanceInfo(embeddedServer.getHost(), embeddedServer.getPort(), applicationName, this.explicitInstanceId ? instanceId : applicationName);
            if (dataCenterInfo != null) {
                this.instanceInfo.setDataCenterInfo(dataCenterInfo);
            }
        }

        public boolean isExplicitInstanceId() {
            return this.explicitInstanceId;
        }

        public InstanceInfo getInstanceInfo() {
            LeaseInfo leaseInfo = this.leaseInfo.build();
            this.instanceInfo.setLeaseInfo(leaseInfo);
            return this.instanceInfo;
        }
    }

    @ConfigurationProperties(value="discovery")
    public static class EurekaDiscoveryConfiguration
    extends DiscoveryConfiguration {
        private boolean useSecurePort;

        public boolean isUseSecurePort() {
            return this.useSecurePort;
        }

        public void setUseSecurePort(boolean useSecurePort) {
            this.useSecurePort = useSecurePort;
        }
    }

    @ConfigurationProperties(value="pool")
    public static class EurekaConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

